/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce.workflow;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.perforce.PerforceManager;
import com.atlassian.jirafisheyeplugin.perforce.customfields.JobSwitchCFType;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.perforce.api.CommitException;
import com.perforce.api.Job;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateJobFunction
extends AbstractJiraFunctionProvider {
    private static Logger log = LoggerFactory.getLogger(CreateJobFunction.class);
    private final PerforceManager perforceManager;
    private final CustomFieldManager customFieldManager;
    private final SoftwareLicenseVerifier softwareLicenseVerifier;

    public CreateJobFunction(PerforceManager perforceManager, CustomFieldManager customFieldManager, SoftwareLicenseVerifier softwareLicenseVerifier) {
        this.perforceManager = perforceManager;
        this.customFieldManager = customFieldManager;
        this.softwareLicenseVerifier = softwareLicenseVerifier;
    }

    public void execute(Map transientVars, Map args, PropertySet ps) {
        MutableIssue issue = this.getIssue(transientVars);
        if (issue.getProjectObject() == null) {
            log.warn("Post function got issue without a project, aborting execution");
            return;
        }
        if (!this.softwareLicenseVerifier.isAllowedForSoftwareUsers(issue.getProjectObject(), WorkflowUtil.getCallerUser((Map)transientVars))) {
            log.trace("Not executing post function because the user has no devtools permission");
            return;
        }
        if (!this.perforceManager.requiresJob((Issue)issue)) {
            Job job = this.perforceManager.makeJob((Issue)issue);
            try {
                job.commit();
                for (CustomField customField : this.customFieldManager.getCustomFieldObjects(issue.getGenericValue())) {
                    FieldLayoutItem fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(issue.getGenericValue()).getFieldLayoutItem((OrderableField)customField);
                    DefaultIssueChangeHolder issueChangeHolder = new DefaultIssueChangeHolder();
                    if (!(customField.getCustomFieldType() instanceof JobSwitchCFType)) continue;
                    customField.updateValue(fieldLayoutItem, (Issue)issue, new ModifiedValue(null, (Object)"true"), (IssueChangeHolder)issueChangeHolder);
                    break;
                }
            }
            catch (CommitException e) {
                log.error("Could not commit job: " + job, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.error("Could not commit job " + job + " : " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static FunctionDescriptor makeDescriptor() {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", CreateJobFunction.class.getName());
        return descriptor;
    }
}

