/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce.listener;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jirafisheyeplugin.perforce.PerforceManager;
import com.perforce.api.CommitException;
import com.perforce.api.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobUpdateListener
extends AbstractIssueEventListener {
    private static Logger log = LoggerFactory.getLogger(JobUpdateListener.class);
    private static final String LISTENER_NAME = "Perforce Job Update Listener";

    public void workflowEvent(IssueEvent event) {
        Issue issue = event.getIssue();
        if (this.getPerforceManager().isValidConfig(issue)) {
            if (EventType.ISSUE_DELETED_ID.equals(event.getEventTypeId())) {
                this.getPerforceManager().deleteJob(issue);
            } else if (this.getPerforceManager().requiresJob(issue)) {
                this.createJob(issue);
            } else {
                this.getPerforceManager().deleteJob(issue);
            }
        }
    }

    protected void createJob(Issue issue) {
        Job job = this.getPerforceManager().makeJob(issue);
        try {
            job.commit();
        }
        catch (CommitException e) {
            log.error("Could not commit job: " + job, (Throwable)e);
        }
    }

    public boolean isInternal() {
        return true;
    }

    public static void install() throws Exception {
        if (!JobUpdateListener.getListenerManager().getListeners().containsKey(LISTENER_NAME)) {
            JobUpdateListener.getListenerManager().createListener(LISTENER_NAME, JobUpdateListener.class);
            log.info("Installed listener Perforce Job Update Listener");
        }
    }

    public static void remove() throws Exception {
        if (JobUpdateListener.getListenerManager().getListeners().containsKey(LISTENER_NAME)) {
            JobUpdateListener.getListenerManager().deleteListener(JobUpdateListener.class);
            log.info("Removed listener Perforce Job Update Listener");
        }
    }

    private static ListenerManager getListenerManager() {
        return (ListenerManager)ComponentManager.getComponentInstanceOfType(ListenerManager.class);
    }

    protected PerforceManager getPerforceManager() {
        return (PerforceManager)ComponentManager.getOSGiComponentInstanceOfType(PerforceManager.class);
    }
}

