/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce.customfields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.TextCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.software.api.permissions.SoftwareProjectPermissions;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.perforce.PerforceManager;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JobSwitchCFType
extends TextCFType {
    public static final String WITHOUT_PERFORCE_JOB = "false";
    public static final String WITH_PERFORCE_JOB = "true";
    public static final String NO_PERMISSION = "no_permission";
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PerforceManager perforceManager;
    private PerforceConfigStore perforceConfigStore;

    public JobSwitchCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, PerforceManager perforceManager, PerforceConfigStore perforceConfigStore) {
        super(customFieldValuePersister, genericConfigManager);
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.perforceManager = perforceManager;
        this.perforceConfigStore = perforceConfigStore;
    }

    public Object getValueFromIssue(CustomField customField, Issue issue) {
        if (this.permissionManager.hasPermission(SoftwareProjectPermissions.VIEW_DEV_TOOLS, issue.getProjectObject(), this.authenticationContext.getLoggedInUser())) {
            if (WITH_PERFORCE_JOB.equals(super.getValueFromIssue(customField, issue))) {
                return WITH_PERFORCE_JOB;
            }
            return WITHOUT_PERFORCE_JOB;
        }
        return NO_PERMISSION;
    }

    public String getValueFromCustomFieldParams(CustomFieldParams customFieldParams) {
        Collection normalParams = customFieldParams.getValuesForKey(null);
        return normalParams != null && normalParams.contains(WITH_PERFORCE_JOB) ? WITH_PERFORCE_JOB : WITHOUT_PERFORCE_JOB;
    }

    String constructViewJobLink(String jobId, String urlFormat) {
        if (jobId == null) {
            return null;
        }
        if (TextUtils.stringSet((String)urlFormat)) {
            return urlFormat.replaceAll("\\[JOBNAME\\]", jobId);
        }
        return null;
    }

    public Map<String, Object> getVelocityParameters(Issue issue, CustomField customField, FieldLayoutItem fieldLayoutItem) {
        PerforceConfig perforceConfig;
        Map params = super.getVelocityParameters(issue, customField, fieldLayoutItem);
        if (issue != null && TextUtils.stringSet((String)issue.getKey()) && (perforceConfig = this.getPerforceConfig(issue)) != null) {
            String urlFormat = perforceConfig.getUrlJobView();
            params.put("jobviewlink", this.constructViewJobLink(issue.getKey(), urlFormat));
            Collection<String> oldJobs = this.perforceManager.getOldJobs(issue);
            if (!oldJobs.isEmpty()) {
                HashMap<String, String> oldJobMap = new HashMap<String, String>();
                for (String oldJob : oldJobs) {
                    oldJobMap.put(oldJob, this.constructViewJobLink(oldJob, urlFormat));
                }
                params.put("oldjobs", oldJobMap);
            }
        }
        params.put("i18n", this.authenticationContext.getI18nHelper());
        params.put("jfpTextutils", new JiraFisheyeEscapeTools());
        return params;
    }

    private PerforceConfig getPerforceConfig(Issue issue) {
        PerforceConfig perforceConfig = this.perforceConfigStore.getConfig(issue);
        if (perforceConfig == null) {
            perforceConfig = this.perforceConfigStore.getDefaultConfig();
        }
        return perforceConfig;
    }
}

