/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce;

import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jirafisheyeplugin.perforce.PerforceProperties;
import com.atlassian.jirafisheyeplugin.perforce.PerforceUtils;
import com.perforce.api.Env;
import com.perforce.api.PerforceException;
import java.util.Properties;

public class ValidEnv
extends Env {
    private final JiraHome jiraHome;
    private final PerforceProperties perforceProperties;
    private final AttachmentPathManager attachmentPathManager;

    public ValidEnv(Env base, JiraHome jiraHome, PerforceProperties perforceProperties, AttachmentPathManager attachmentPathManager) {
        super(base);
        this.jiraHome = jiraHome;
        this.perforceProperties = perforceProperties;
        this.attachmentPathManager = attachmentPathManager;
    }

    public ValidEnv(String propfile, JiraHome jiraHome, PerforceProperties perforceProperties, AttachmentPathManager attachmentPathManager) throws PerforceException {
        super(propfile);
        this.jiraHome = jiraHome;
        this.perforceProperties = perforceProperties;
        this.attachmentPathManager = attachmentPathManager;
    }

    public ValidEnv(Properties props, JiraHome jiraHome, PerforceProperties perforceProperties, AttachmentPathManager attachmentPathManager) {
        super(props);
        this.jiraHome = jiraHome;
        this.perforceProperties = perforceProperties;
        this.attachmentPathManager = attachmentPathManager;
    }

    private String ensurePathIsValid(String path) {
        if (PerforceUtils.isValidPerforceExecutable(path, this.jiraHome, this.attachmentPathManager, this.perforceProperties)) {
            return path;
        }
        throw new RuntimeException(String.format("invalid perforce executable detected:[%s]", path));
    }

    public String getExecutable() {
        return this.ensurePathIsValid(super.getExecutable());
    }
}

