/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jirafisheyeplugin.util.ResourceUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketFileUtils {
    private static Logger log = LoggerFactory.getLogger(TicketFileUtils.class);
    protected static TicketFileResolver resolver = new TicketFileResolver();

    public static String retrievePasswordFromTicketfile(String ticketfile, String user, String port) throws IOException {
        try (BufferedReader ticketReader = null;){
            String ticket;
            ticketReader = resolver.resolveTicketStreamReader(ticketfile);
            String firstMatchingUserPassword = null;
            while ((ticket = ticketReader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(ticket, "=:");
                String ticketPort = st.nextToken() + ":" + st.nextToken();
                String ticketUser = st.nextToken();
                String ticketPassword = st.nextToken();
                if (!ticketUser.equals(user)) continue;
                if (ticketPort.equals(port)) {
                    String string = ticketPassword;
                    return string;
                }
                if (firstMatchingUserPassword != null) continue;
                firstMatchingUserPassword = ticketPassword;
            }
            if (firstMatchingUserPassword != null) {
                String string = firstMatchingUserPassword;
                return string;
            }
            try {
                throw new InfrastructureException("Unable to retrieve the ticket number for the user " + user + " from the ticket file " + ticketfile + ".");
            }
            catch (IOException e) {
                throw new InfrastructureException("Error encountered while attempting to read the Perforce ticket file.", (Throwable)e);
            }
        }
    }

    public static class TicketFileResolver {
        protected BufferedReader resolveTicketStreamReader(String ticketFile) {
            InputStream ticketStream = ResourceUtil.getResourceAsStream(ticketFile, TicketFileUtils.class);
            if (ticketStream == null) {
                try {
                    ticketStream = new FileInputStream(new File(ticketFile));
                    log.info("Found ticketfile on file system at " + ticketFile);
                }
                catch (FileNotFoundException e) {
                    throw new InfrastructureException("Unable to find the ticket file: '" + ticketFile + "' on classpath or file system.");
                }
            }
            return new BufferedReader(new InputStreamReader(ticketStream));
        }
    }
}

