/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce;

import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jirafisheyeplugin.perforce.PerforceProperties;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class PerforceUtils {
    public static boolean isValidPerforceExecutable(String path, JiraHome jiraHome, AttachmentPathManager attachmentPathManager, PerforceProperties perforceProperties) {
        return PerforceUtils.isInWhitelist(path, perforceProperties) && !PerforceUtils.isInJiraDirectories(path, jiraHome, attachmentPathManager) && !PerforceUtils.isInNetworkSharePath(path, perforceProperties);
    }

    private static boolean isInNetworkSharePath(String path, PerforceProperties perforceProperties) {
        if (perforceProperties.isNetworkShareAllowed()) {
            return false;
        }
        return path.startsWith("\\\\");
    }

    private static boolean isInJiraDirectories(String exePath, JiraHome jiraHome, AttachmentPathManager attachmentPathManager) {
        List<File> problematicDirs = Arrays.asList(new File(attachmentPathManager.getAttachmentPath()), jiraHome.getHome(), jiraHome.getCachesDirectory(), jiraHome.getDataDirectory(), jiraHome.getExportDirectory(), jiraHome.getLogDirectory(), jiraHome.getPluginsDirectory());
        for (File dir : problematicDirs) {
            if (!PerforceUtils.isFileInsidePath(exePath, dir.getPath())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFileInsidePath(String exePath, String path) {
        File file = PerforceUtils.getCanonicalFileSafely(path);
        File p4exe = PerforceUtils.getCanonicalFileSafely(exePath);
        File p4exeParent = p4exe.getParentFile();
        boolean hasParent = true;
        while (hasParent) {
            if (p4exeParent == null) {
                hasParent = false;
                continue;
            }
            if (file.equals(p4exeParent)) {
                return true;
            }
            p4exeParent = p4exeParent.getParentFile();
        }
        return false;
    }

    private static File getCanonicalFileSafely(String path) {
        File file;
        try {
            file = new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("error locating [%s]", path), e);
        }
        return file;
    }

    private static boolean isInWhitelist(String exec, PerforceProperties perforceProperties) {
        for (Pattern p : perforceProperties.getExecutableNamePatterns()) {
            if (!p.matcher(exec).matches()) continue;
            return true;
        }
        return false;
    }
}

