/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce;

import com.atlassian.jirafisheyeplugin.perforce.PerforceManagerImpl;
import com.atlassian.jirafisheyeplugin.perforce.PerforceProperties;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerforcePropertiesImpl
implements PerforceProperties {
    private static Logger log = LoggerFactory.getLogger(PerforcePropertiesImpl.class);
    private List<Pattern> p4ExecutablePatterns;
    private List<String> p4Executables;
    private Properties p4Properties;

    @Override
    public List<Pattern> getExecutableNamePatterns() {
        this.loadP4ExecutablePatterns();
        return this.p4ExecutablePatterns;
    }

    @Override
    public boolean isNetworkShareAllowed() {
        if (System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
            this.loadP4Properties();
            return this.getProperty("p4.executable.allow.network.share.path", "false");
        }
        log.debug(String.format("os.name is [%s], network share p4 executable path allowed", System.getProperty("os.name")));
        return true;
    }

    private boolean getProperty(String p, String def) {
        p = System.getProperty(p, this.p4Properties.getProperty(p, def));
        return Boolean.parseBoolean(p.trim());
    }

    @Override
    public List<String> getWhitelist() {
        this.loadP4ExecutablePatterns();
        return this.p4Executables;
    }

    private void loadP4ExecutablePatterns() {
        this.loadP4Properties();
        if (this.p4ExecutablePatterns == null) {
            String allowedPattern = this.p4Properties.getProperty("p4.executable.allowed.pattern");
            if (allowedPattern == null) {
                this.p4ExecutablePatterns = Collections.singletonList(Pattern.compile(".*", 32));
                this.p4Executables = Collections.singletonList("");
            } else {
                String[] allowedPatterns = this.cleanPattern(allowedPattern).split(",");
                this.p4ExecutablePatterns = new ArrayList<Pattern>(allowedPattern.length());
                this.p4Executables = new ArrayList<String>(allowedPattern.length());
                for (String pattern : allowedPatterns) {
                    this.p4ExecutablePatterns.add(Pattern.compile("^.*" + Pattern.quote(System.getProperty("file.separator", "/")) + Pattern.quote(pattern.trim()) + "$"));
                    this.p4Executables.add(pattern.trim());
                }
            }
        }
    }

    private String cleanPattern(String allowedPattern) {
        return allowedPattern.replaceAll(",\\s*,+", ",").replaceAll("^,", "").replaceAll(",$", "");
    }

    private void loadP4Properties() {
        if (this.p4Properties == null) {
            this.p4Properties = new Properties();
            InputStream input = null;
            try {
                input = this.getResourceStream();
                if (input != null) {
                    this.p4Properties.load(input);
                } else {
                    log.error("unable to load /perforce-jira-plugin.properties: file not found.");
                }
            }
            catch (Exception e) {
                log.error("unable to load /perforce-jira-plugin.properties", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }

    protected InputStream getResourceStream() {
        return PerforceManagerImpl.class.getResourceAsStream("/perforce-jira-plugin.properties");
    }
}

