/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.domain.jira.IssueHelper;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.perforce.PerforceManager;
import com.atlassian.jirafisheyeplugin.perforce.PerforceProperties;
import com.atlassian.jirafisheyeplugin.perforce.PerforceUtils;
import com.atlassian.jirafisheyeplugin.perforce.customfields.JobSwitchCFType;
import com.opensymphony.util.TextUtils;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.Job;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerforceManagerImpl
implements PerforceManager {
    private static final String TEST_JOB = "JIRA_TEST_JOB";
    private static Logger log = LoggerFactory.getLogger(PerforceManagerImpl.class);
    private final ApplicationProperties applicationProperties;
    private final IssueHelper issueHelper;
    private final PerforceConfigStore p4ConfigStore;
    private final FishEyeProperties fisheyeProperties;
    private final PerforceProperties perforceProperties;
    private final JiraHome jiraHome;
    private final AttachmentPathManager attachmentPathManager;
    private final IssueManager issueManager;

    public PerforceManagerImpl(ApplicationProperties applicationProperties, IssueHelper issueHelper, PerforceConfigStore p4ConfigStore, FishEyeProperties fisheyeProperties, PerforceProperties perforceProperties, JiraHome jiraHome, AttachmentPathManager attachmentPathManager, IssueManager issueManager) {
        this.applicationProperties = applicationProperties;
        this.issueHelper = issueHelper;
        this.p4ConfigStore = p4ConfigStore;
        this.fisheyeProperties = fisheyeProperties;
        this.perforceProperties = perforceProperties;
        this.jiraHome = jiraHome;
        this.attachmentPathManager = attachmentPathManager;
        this.issueManager = issueManager;
    }

    @Override
    public List<String> getValidExecutableNames() {
        return this.perforceProperties.getWhitelist();
    }

    @Override
    public boolean isValidPerforceExecutable(String path) {
        return PerforceUtils.isValidPerforceExecutable(path, this.jiraHome, this.attachmentPathManager, this.perforceProperties);
    }

    @Override
    public Job makeJob(Issue issue) {
        PerforceConfig p4Config = this.p4ConfigStore.getConfig(issue);
        Job job = new Job(p4Config.getEnvironment(), issue.getKey());
        job.setDescription(issue.getSummary());
        if (issue.getResolutionObject() != null) {
            job.setStatus("closed");
        } else {
            job.setStatus("open");
        }
        job.setField("IssueStatus", issue.getStatusObject().getName());
        if (issue.getReporterUser() != null) {
            job.setUser(issue.getReporterUser().getName());
        }
        if (issue.getAssigneeUser() != null && TextUtils.stringSet((String)issue.getAssigneeUser().getName())) {
            job.setField("Assignee", issue.getAssigneeUser().getName());
        }
        job.setField("Project", JiraKeyUtils.getProjectKeyFromIssueKey((String)issue.getKey()));
        if (issue.getIssueTypeObject() != null && TextUtils.stringSet((String)issue.getIssueTypeObject().getName())) {
            job.setField("Type", issue.getIssueTypeObject().getName());
        }
        if (issue.getPriorityObject() != null && TextUtils.stringSet((String)issue.getPriorityObject().getName())) {
            job.setField("Priority", issue.getPriorityObject().getName());
        }
        Map fieldMap = p4Config.getCustomFieldMappings();
        CustomFieldManager cfManager = this.getCustomFieldManager();
        for (Map.Entry e : fieldMap.entrySet()) {
            try {
                Long customFieldId = (Long)e.getKey();
                String p4FieldName = (String)e.getValue();
                CustomField cf = cfManager.getCustomFieldObject(customFieldId);
                if (cf == null) {
                    log.warn("Could not find custom field with id=" + customFieldId + " (maybe deleted?). Can't add to P4 job " + job.getName());
                    continue;
                }
                this.setCustomJobField(cf, p4FieldName, issue, job);
            }
            catch (Exception ex) {
                log.error("Failed to copy custom field to jobspec [" + e.getKey() + ":" + e.getValue() + "]", (Throwable)ex);
            }
        }
        job.setField("URL", this.applicationProperties.getString("jira.baseurl") + "/browse/" + issue.getKey());
        return job;
    }

    @Override
    public void deleteJob(Issue issue) {
        if (this.jobExists(issue.getKey())) {
            String jobName = this.getJob(issue).getName();
            try {
                this.deleteJob(jobName, this.p4ConfigStore.getConfig(issue));
            }
            catch (IOException e) {
                log.error("Could not delete the job associated with the issue " + issue.getString("key") + ".", (Throwable)e);
            }
        }
    }

    private void deleteJob(String jobName, PerforceConfig p4cfg) throws IOException {
        String[] cmd = new String[]{"p4", "job", "-d", jobName};
        P4Process p = new P4Process(p4cfg.getEnvironment());
        p.setRawMode(true);
        p.exec(cmd);
    }

    private void setCustomJobField(CustomField cf, String p4FieldName, Issue issue, Job job) {
        Object fieldValue;
        if (cf != null && (fieldValue = cf.getValue(issue)) != null) {
            String strValue = cf.getValue(issue).toString();
            job.setField(p4FieldName, strValue);
        }
    }

    private CustomFieldManager getCustomFieldManager() {
        return (CustomFieldManager)ComponentManager.getComponentInstanceOfType(CustomFieldManager.class);
    }

    @Override
    public boolean requiresJob(Issue issue) {
        return this.isJobFieldSet(issue) || this.fisheyeProperties.getCollection("fisheye.p4.always.create.jobs").contains(issue.getProjectObject().getKey());
    }

    @Override
    public Job getJob(Issue issue) {
        Env environment = this.p4ConfigStore.getConfig(issue).getEnvironment();
        return Job.getJob((Env)environment, (String)issue.getKey());
    }

    private boolean isJobFieldSet(Issue issue) {
        CustomFieldManager customFieldManager = (CustomFieldManager)ComponentManager.getComponentInstanceOfType(CustomFieldManager.class);
        for (CustomField customField : customFieldManager.getCustomFieldObjects(issue)) {
            if (customField == null || !(customField.getCustomFieldType() instanceof JobSwitchCFType) || !"true".equals(customField.getValue(issue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getOldJobs(Issue issue) {
        Collection<String> oldIssueKeys = this.issueHelper.getOldIssueKeys(issue.getKey());
        ArrayList<String> existingOldJobs = new ArrayList<String>();
        for (String oldIssueKey : oldIssueKeys) {
            if (!this.jobExists(oldIssueKey)) continue;
            existingOldJobs.add(oldIssueKey);
        }
        return existingOldJobs;
    }

    @Override
    public boolean jobExists(String issueKey) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        return issue != null && this.jobExists(this.p4ConfigStore.getConfig(issue.getProjectObject()), issueKey);
    }

    private boolean jobExists(PerforceConfig config, String jobName) {
        String[] cmd = new String[]{"p4", "jobs", "-e", jobName};
        try {
            String l;
            P4Process p = new P4Process(config.getEnvironment());
            p.setRawMode(true);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (!l.startsWith("info: " + jobName)) continue;
                return true;
            }
        }
        catch (IOException e) {
            Debug.out((int)1, (Throwable)e);
        }
        return false;
    }

    @Override
    public void testConnection(PerforceConfig p4cfg) throws PerforceException, IOException {
        if (!p4cfg.isValid()) {
            throw new PerforceException("Invalid Perforce config");
        }
        Env env = p4cfg.getEnvironment();
        log.debug("=====");
        log.debug("using env = " + env);
        log.debug("=====");
        Job testJob = new Job(env, TEST_JOB);
        testJob.setDescription("test");
        testJob.setStatus("open");
        testJob.setUser("test");
        testJob.setField("Project", "TST");
        testJob.setField("IssueStatus", "test_status");
        testJob.setField("Priority", "test_priority");
        testJob.setField("Type", "test_issuetype");
        testJob.setField("URL", "http://test_url");
        Collection p4fields = p4cfg.getCustomFieldMappings().values();
        Iterator it = p4fields.iterator();
        while (it.hasNext()) {
            testJob.setField((String)it.next(), "testvalue");
        }
        testJob.commit();
        if (!this.jobExists(p4cfg, TEST_JOB)) {
            throw new PerforceException("Failed to create Perforce job!");
        }
        this.deleteJob(testJob.getName(), p4cfg);
    }

    @Override
    public boolean isValidConfig(Issue issue) {
        PerforceConfig config = this.p4ConfigStore.getConfig(issue);
        return config != null && config.isValid();
    }
}

