/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce;

import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.Refreshable;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.perforce.MutablePerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.NullPerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigImpl;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.perforce.PerforceProperties;
import com.atlassian.jirafisheyeplugin.perforce.listener.JobUpdateListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class PerforceConfigStoreImpl
implements PerforceConfigStore,
Refreshable,
FishEyePropertyKeys,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(PerforceConfigStoreImpl.class);
    private PerforceConfig defaultConfig;
    private List<PerforceConfig> configs;
    private Map<String, PerforceConfig> projectConfigs;
    private Map<Integer, Collection<String>> configProjects;
    private final FishEyeProperties properties;
    private final JiraHome jiraHome;
    private final PerforceProperties perforceProperties;
    private final AttachmentPathManager attachmentPathManager;
    private final RefreshManager refreshManager;

    public PerforceConfigStoreImpl(FishEyeProperties properties, JiraHome jiraHome, PerforceProperties perforceProperties, AttachmentPathManager attachmentPathManager, RefreshManager refreshManager) {
        this.properties = properties;
        this.jiraHome = jiraHome;
        this.perforceProperties = perforceProperties;
        this.attachmentPathManager = attachmentPathManager;
        this.refreshManager = refreshManager;
    }

    @Override
    public List<PerforceConfig> getAllConfigs() {
        return new CopyOnWriteArrayList<PerforceConfig>(this.configs);
    }

    @Override
    public synchronized void saveConfig(PerforceConfig config) {
        if (config.getId() != null) {
            Integer id = config.getId();
            this.properties.setText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.port", id), config.getPort());
            this.properties.setText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.executable", id), config.getExecutablePath());
            this.properties.setString(PerforceConfigStoreImpl.updateKey("fisheye.p4.user", id), config.getUser());
            this.properties.setString(PerforceConfigStoreImpl.updateKey("fisheye.p4.password", id), config.getPassword());
            this.properties.setString(PerforceConfigStoreImpl.updateKey("fisheye.p4.client", id), config.getClient());
            this.properties.setLong(PerforceConfigStoreImpl.updateKey("fisheye.p4.timeout", id), config.getTimeout());
            this.properties.setString(PerforceConfigStoreImpl.updateKey("fisheye.p4.charset", id), config.getCharset());
            this.properties.setText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.ticketfile", id), config.getTicketfile());
            this.properties.setString(PerforceConfigStoreImpl.updateKey("fisheye.p4.loglevel", id), config.getLogLevel());
            this.properties.setString(PerforceConfigStoreImpl.updateKey("fisheye.p4.sysdrive", id), config.getSysDrive());
            this.properties.setText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.sysroot", id), config.getSysRoot());
            this.properties.setText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.url.jobview", id), config.getUrlJobView());
            if (config.getCustomFieldMappings() != null) {
                this.properties.setMap(PerforceConfigStoreImpl.updateKey("fisheye.p4.custom.fields", id), config.getCustomFieldMappings());
            }
            this.refresh();
        } else {
            Integer id = this.getNextId();
            ((MutablePerforceConfig)config).setId(id);
            Collection<String> ids = this.properties.getCollection("fisheye.p4.configs");
            ids.add(id.toString());
            this.properties.setCollection("fisheye.p4.configs", ids);
            this.saveConfig(config);
            if (this.defaultConfig == null) {
                this.setDefaultConfig(id);
            }
        }
    }

    protected Integer getNextId() {
        Collection<String> ids = this.properties.getCollection("fisheye.p4.configs");
        int last = 0;
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            int id = Integer.parseInt(it.next());
            if (id <= last) continue;
            last = id;
        }
        return new Integer(last + 1);
    }

    @Override
    public synchronized void deleteConfig(Integer id) {
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.port", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.executable", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.user", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.password", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.client", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.timeout", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.charset", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.ticketfile", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.loglevel", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.sysdrive", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.sysroot", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.url.jobview", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.custom.fields", id));
        this.properties.removeProperty(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", id));
        Collection<String> ids = this.properties.getCollection("fisheye.p4.configs");
        ids.remove(id.toString());
        if (ids.isEmpty()) {
            this.properties.removeProperty("fisheye.p4.unmapped.projects");
            this.properties.removeProperty("fisheye.p4.default");
        }
        this.properties.setCollection("fisheye.p4.configs", ids);
        this.refresh();
    }

    @Override
    public PerforceConfig getConfig(Project project) {
        return this.getConfig(project.getKey());
    }

    @Override
    public PerforceConfig getConfig(String projectKey) {
        PerforceConfig config = this.projectConfigs.get(projectKey);
        if (config == null) {
            config = this.defaultConfig;
        }
        return config;
    }

    @Override
    public PerforceConfig getConfig(Issue issue) {
        return this.getConfig(issue.getProjectObject());
    }

    @Override
    public PerforceConfig getConfig(Integer configId) {
        if (NullPerforceConfig.ID.equals(configId)) {
            return NullPerforceConfig.INSTANCE;
        }
        for (PerforceConfig cfg : this.configs) {
            if (!configId.equals(cfg.getId())) continue;
            return cfg;
        }
        return null;
    }

    @Override
    public PerforceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public void setDefaultConfig(Integer configId) {
        PerforceConfig newDefault = this.getConfig(configId);
        if (newDefault != null) {
            this.defaultConfig = newDefault;
            this.properties.setString("fisheye.p4.default", configId.toString());
        } else {
            log.error("Could not set default, config with id='" + configId + "' doesn't exist!");
        }
    }

    @Override
    public synchronized void associateConfig(Project project, PerforceConfig config) {
        if (NullPerforceConfig.ID.equals(config.getId())) {
            Collection<String> pKeys = this.properties.getCollection("fisheye.p4.unmapped.projects");
            if (!pKeys.add(project.getKey())) {
                log.info("Couldn't add " + project.getKey() + " to NullPerforceConfig (" + config.getId() + "), maybe already associated?");
            }
            this.properties.setCollection("fisheye.p4.unmapped.projects", pKeys);
        } else {
            Collection<String> pKeys = this.properties.getCollection(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", config.getId()));
            if (!pKeys.add(project.getKey())) {
                log.info("Couldn't add " + project.getKey() + " to P4 config " + config.getId() + ", maybe already associated?");
            }
            this.properties.setCollection(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", config.getId()), pKeys);
        }
        this.refresh();
    }

    @Override
    public void associateProjectKeysWithConfig(Collection<String> projects, PerforceConfig config) {
        if (projects == null || projects.isEmpty()) {
            log.info("null or empty list passed to associateProjectKeysWithConfig()");
            return;
        }
        if (NullPerforceConfig.ID.equals(config.getId())) {
            Collection<String> pKeys = this.properties.getCollection("fisheye.p4.unmapped.projects");
            if (!pKeys.addAll(projects)) {
                log.info("Couldn't add supplied keys to NullPerforceConfig (" + config.getId() + "), maybe already associated?");
                return;
            }
            this.properties.setCollection("fisheye.p4.unmapped.projects", pKeys);
        } else {
            Collection<String> pKeys = this.properties.getCollection(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", config.getId()));
            if (!pKeys.addAll(projects)) {
                log.info("Couldn't add supplied keys to P4 config " + config.getId() + ", maybe already associated?");
                return;
            }
            this.properties.setCollection(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", config.getId()), pKeys);
        }
        this.refresh();
    }

    @Override
    public synchronized void disassociateConfig(Project project, PerforceConfig config) {
        if (NullPerforceConfig.ID.equals(config.getId())) {
            Collection<String> pKeys = this.properties.getCollection("fisheye.p4.unmapped.projects");
            if (!pKeys.remove(project.getKey())) {
                log.info("Couldn't remove " + project.getKey() + " from NullPerforceConfig (" + config.getId() + "), maybe not associated?");
                return;
            }
            this.properties.setCollection("fisheye.p4.unmapped.projects", pKeys);
        } else {
            Collection<String> pKeys = this.properties.getCollection(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", config.getId()));
            if (!pKeys.remove(project.getKey())) {
                log.info("Couldn't remove " + project.getKey() + " from P4 config " + config.getId() + ", maybe not associated?");
            }
            this.properties.setCollection(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", config.getId()), pKeys);
        }
        this.refresh();
    }

    @Override
    public void disassociateProjectKeysFromConfig(Collection<String> projects, PerforceConfig config) {
        if (projects == null || projects.isEmpty()) {
            log.info("null or empty list passed to disassociateProjectKeysWithConfig()");
            return;
        }
        if (NullPerforceConfig.ID.equals(config.getId())) {
            Collection<String> pKeys = this.properties.getCollection("fisheye.p4.unmapped.projects");
            if (!pKeys.removeAll(projects)) {
                log.info("Couldn't remove supplied keys from NullPerforceConfig (" + config.getId() + "), maybe already associated?");
                return;
            }
            this.properties.setCollection("fisheye.p4.unmapped.projects", pKeys);
        } else {
            Collection<String> pKeys = this.properties.getCollection(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", config.getId()));
            if (!pKeys.removeAll(projects)) {
                log.info("Couldn't remove supplied keys from P4 config " + config.getId() + ", maybe not associated?");
            }
            this.properties.setCollection(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", config.getId()), pKeys);
        }
        this.refresh();
    }

    @Override
    public Collection<String> getAssociatedProjects(PerforceConfig config) {
        Collection<String> prjKeys = this.configProjects.get(config.getId());
        return prjKeys != null ? new CopyOnWriteArrayList<String>(prjKeys) : new CopyOnWriteArrayList();
    }

    @Override
    public synchronized void setCustomFieldMap(Map customFields, Integer configId) {
        this.properties.setMap(PerforceConfigStoreImpl.updateKey("fisheye.p4.custom.fields", configId), customFields);
        this.refresh();
    }

    @Override
    public synchronized void refresh() {
        this.defaultConfig = null;
        boolean hasValidConfig = false;
        ArrayList<PerforceConfig> newConfigs = new ArrayList<PerforceConfig>();
        HashMap<String, PerforceConfig> newProjectConfigs = new HashMap<String, PerforceConfig>();
        HashMap<Integer, Collection<String>> newConfigProjects = new HashMap<Integer, Collection<String>>();
        Collection<String> p4CfgIds = this.properties.getCollection("fisheye.p4.configs");
        Iterator<String> iterator = p4CfgIds.iterator();
        while (iterator.hasNext()) {
            Integer id = new Integer(iterator.next());
            String port = this.properties.getText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.port", id));
            String exec = this.properties.getText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.executable", id));
            String user = this.properties.getString(PerforceConfigStoreImpl.updateKey("fisheye.p4.user", id));
            String pass = this.properties.getString(PerforceConfigStoreImpl.updateKey("fisheye.p4.password", id));
            String clnt = this.properties.getString(PerforceConfigStoreImpl.updateKey("fisheye.p4.client", id));
            Long tout = this.properties.getLong(PerforceConfigStoreImpl.updateKey("fisheye.p4.timeout", id));
            String cset = this.properties.getString(PerforceConfigStoreImpl.updateKey("fisheye.p4.charset", id));
            String tckt = this.properties.getText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.ticketfile", id));
            String logl = this.properties.getString(PerforceConfigStoreImpl.updateKey("fisheye.p4.loglevel", id));
            String sysd = this.properties.getString(PerforceConfigStoreImpl.updateKey("fisheye.p4.sysdrive", id));
            String sysr = this.properties.getText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.sysroot", id));
            String jurl = this.properties.getText(PerforceConfigStoreImpl.updateKey("fisheye.p4.text.url.jobview", id));
            Map cfld = this.getCustomFieldMap(id);
            PerforceConfigImpl perforceConfig = new PerforceConfigImpl(id, port, exec, user, pass, clnt, tout, cset, tckt, logl, sysd, sysr, jurl, cfld, this.jiraHome, this.perforceProperties, this.attachmentPathManager);
            newConfigs.add(perforceConfig);
            Collection<String> projects = this.properties.getCollection(PerforceConfigStoreImpl.updateKey("fisheye.p4.projects", perforceConfig.getId()));
            newConfigProjects.put(perforceConfig.getId(), projects);
            for (String pKey : projects) {
                newProjectConfigs.put(pKey, perforceConfig);
            }
            if (!perforceConfig.isValid()) continue;
            hasValidConfig = true;
        }
        Collection<String> unmappedProjects = this.properties.getCollection("fisheye.p4.unmapped.projects");
        for (String pKey : unmappedProjects) {
            newProjectConfigs.put(pKey, NullPerforceConfig.INSTANCE);
        }
        this.configs = newConfigs;
        this.projectConfigs = newProjectConfigs;
        this.configProjects = newConfigProjects;
        String defaultId = this.properties.getString("fisheye.p4.default");
        if (defaultId != null) {
            this.defaultConfig = this.getConfig(new Integer(defaultId));
        }
        if (this.defaultConfig == null && !this.configs.isEmpty()) {
            this.defaultConfig = this.configs.get(0);
        }
        this.installListenerIfValidConfigExists(hasValidConfig);
    }

    protected void installListenerIfValidConfigExists(boolean hasValidConfig) {
        try {
            if (hasValidConfig) {
                JobUpdateListener.install();
            } else {
                JobUpdateListener.remove();
            }
        }
        catch (Exception e) {
            log.error("Failed to add/remove JobUpdateListener.", (Throwable)e);
        }
    }

    @Override
    public Map getCustomFieldMap(Integer p4cfgId) {
        Map strCustomFieldMap = this.properties.getMap(PerforceConfigStoreImpl.updateKey("fisheye.p4.custom.fields", p4cfgId));
        HashMap lngCustomFieldMap = new HashMap(strCustomFieldMap.size());
        for (Map.Entry e : strCustomFieldMap.entrySet()) {
            try {
                lngCustomFieldMap.put(new Long((String)e.getKey()), e.getValue());
            }
            catch (Exception ex) {
                log.error("Failed to put k=" + e.getKey() + " v=" + e.getValue() + " into customFieldMap", (Throwable)ex);
            }
        }
        return lngCustomFieldMap;
    }

    @Override
    public int order() {
        return 65;
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshManager.registerRefreshable(this);
    }

    public static String updateKey(String propertyKey, Integer configId) {
        return propertyKey.replaceFirst("fisheye\\.p4\\.", "fisheye.p4." + configId.toString() + ".");
    }
}

