/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.perforce;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.perforce.MutablePerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceProperties;
import com.atlassian.jirafisheyeplugin.perforce.TicketFileUtils;
import com.atlassian.jirafisheyeplugin.perforce.ValidEnv;
import com.opensymphony.util.TextUtils;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.EventLog;
import com.perforce.api.P4JNI;
import com.perforce.api.P4Process;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerforceConfigImpl
implements MutablePerforceConfig,
FishEyePropertyKeys {
    private static Logger log = LoggerFactory.getLogger(PerforceConfigImpl.class);
    private Env environment;
    private Integer id;
    private boolean enabled;
    private String port;
    private String path;
    private String user;
    private String password;
    private String client;
    private String charset;
    private String ticketFile;
    private String logLevel;
    private String sysRoot;
    private String sysDrive;
    private String urlJobView;
    private Long timeout;
    private int authMethod;
    private Map<String, String> customFieldMap;
    private String resolvedAddress = null;

    public PerforceConfigImpl(Integer id, String port, String exec, String user, String pass, String clnt, Long tout, String cset, String tckt, String logl, String sysd, String sysr, String jurl, Map<String, String> cflds, JiraHome jiraHome, PerforceProperties perforceProperties, AttachmentPathManager attachmentPathManager) {
        this.id = id;
        this.enabled = true;
        this.port = port;
        this.path = exec;
        this.user = user;
        this.password = pass;
        this.client = clnt;
        this.timeout = tout;
        this.charset = cset;
        this.ticketFile = tckt;
        this.logLevel = logl;
        this.sysDrive = sysd;
        this.sysRoot = sysr;
        this.urlJobView = jurl;
        this.customFieldMap = cflds;
        this.authMethod = TextUtils.stringSet((String)this.ticketFile) ? 2 : (TextUtils.stringSet((String)this.password) ? 1 : 0);
        this.createEnvironment(jiraHome, perforceProperties, attachmentPathManager);
    }

    private void createEnvironment(JiraHome jiraHome, PerforceProperties perforceProperties, AttachmentPathManager attachmentPathManager) {
        if (!this.isValid()) {
            return;
        }
        Properties props = new Properties(System.getProperties());
        try {
            HashMap<String, Object> configProps = new HashMap<String, Object>();
            if (TextUtils.stringSet((String)this.sysRoot)) {
                configProps.put("p4.sysroot", this.sysRoot);
            }
            if (TextUtils.stringSet((String)this.sysDrive)) {
                configProps.put("p4.sysdrive", this.sysDrive);
            }
            configProps.put("p4.executable", this.path);
            configProps.put("p4.user", this.user);
            configProps.put("p4.password", this.password);
            configProps.put("p4.port", this.port);
            configProps.put("p4.client", this.client);
            if (this.timeout != null) {
                configProps.put("p4.threshold", this.timeout);
            }
            for (Map.Entry entry : configProps.entrySet()) {
                Object value = entry.getValue();
                if (value == null) {
                    props.put(entry.getKey(), "");
                    continue;
                }
                props.put(entry.getKey(), value);
            }
            this.environment = new ValidEnv(props, jiraHome, perforceProperties, attachmentPathManager);
            if (TextUtils.stringSet((String)this.charset)) {
                this.environment.setenv("P4CHARSET", this.charset);
            }
            if (this.getAuthMethod() == 2) {
                if (this.resolveServerAddress()) {
                    log.info("Resolved p4 server " + this.resolvedAddress + " from alias " + this.port);
                } else {
                    log.error("Failed to resolve p4 server from alias: " + this.port);
                }
                this.refreshTicket();
            }
            Debug.setProperties((Properties)props);
            EventLog log = new EventLog(null, "jira-p4.log");
            Debug.setEventLog((EventLog)log);
            Debug.setLogLevel((int)1);
            if (TextUtils.stringSet((String)this.logLevel)) {
                if ("verbose".equalsIgnoreCase(this.logLevel)) {
                    Debug.setDebugLevel((int)99);
                } else if ("notice".equalsIgnoreCase(this.logLevel)) {
                    Debug.setDebugLevel((int)3);
                } else if ("warning".equalsIgnoreCase(this.logLevel)) {
                    Debug.setDebugLevel((int)2);
                } else if ("error".equalsIgnoreCase(this.logLevel)) {
                    Debug.setDebugLevel((int)1);
                } else {
                    Debug.setDebugLevel((int)0);
                }
            }
            Debug.verbose((String)("perforce properties: " + props));
            Debug.verbose((String)("P4 ENVIRONMENT:\n" + this.environment));
            Debug.verbose((String)("P4 using JNI: " + P4JNI.isValid()));
        }
        catch (RuntimeException ex) {
            log.error("Could not load Perforce properties", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Could not load Perforce properties", (Throwable)ex);
            throw new InfrastructureException("Could not load Perforce properties", (Throwable)ex);
        }
    }

    protected boolean resolveServerAddress() {
        try {
            String l;
            P4Process p = new P4Process(this.getEnvironment());
            p.setRawMode(true);
            String[] cmd = new String[]{"p4", "-p", this.port, "info"};
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (!l.toLowerCase().contains("server address:")) continue;
                this.resolvedAddress = l.trim().substring(l.lastIndexOf(32) + 1).trim();
                return true;
            }
        }
        catch (IOException e) {
            log.error("Error resolving server address from potential alias (" + this.port + ")", (Throwable)e);
        }
        return false;
    }

    public void refreshTicket() throws IOException {
        if (this.getAuthMethod() == 2) {
            try {
                String port;
                String user = this.environment.getUser();
                String string = port = this.resolvedAddress != null ? this.resolvedAddress : this.environment.getPort();
                if (!TextUtils.stringSet((String)user)) {
                    throw new InfrastructureException("Perforce Ticket-Based Authentication requires a user to be specified - please ensure you have specified a user.");
                }
                this.environment.setenv("P4PASSWD", TicketFileUtils.retrievePasswordFromTicketfile(this.ticketFile, user, port));
            }
            catch (InfrastructureException e) {
                log.error("error", (Throwable)e);
            }
        }
    }

    public int order() {
        return 50;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public Env getEnvironment() {
        return this.environment;
    }

    @Override
    public boolean isValid() {
        return this.enabled && TextUtils.stringSet((String)this.port) && TextUtils.stringSet((String)this.path) && TextUtils.stringSet((String)this.user);
    }

    @Override
    public Map<String, String> getCustomFieldMappings() {
        return new HashMap<String, String>(this.customFieldMap);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getExecutablePath() {
        return this.path;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getTicketfile() {
        return this.ticketFile;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public Long getTimeout() {
        return this.timeout;
    }

    @Override
    public String getSysRoot() {
        return this.sysRoot;
    }

    @Override
    public String getSysDrive() {
        return this.sysDrive;
    }

    @Override
    public int getAuthMethod() {
        return this.authMethod;
    }

    @Override
    public String getUrlJobView() {
        return this.urlJobView;
    }

    @Override
    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public void setExecutablePath(String path) {
        this.path = path;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setClient(String client) {
        this.client = client;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void setTicketfile(String ticketFile) {
        this.ticketFile = ticketFile;
    }

    @Override
    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void setSysRoot(String sysRoot) {
        this.sysRoot = sysRoot;
    }

    @Override
    public void setSysDrive(String sysDrive) {
        this.sysDrive = sysDrive;
    }

    @Override
    public void setUrlJobView(String jobViewUrl) {
        this.urlJobView = jobViewUrl;
    }

    @Override
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return this.port + (this.client != null ? " (" + this.client + ")" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerforceConfigImpl that = (PerforceConfigImpl)o;
        if (this.authMethod != that.authMethod) {
            return false;
        }
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.charset != null ? !this.charset.equals(that.charset) : that.charset != null) {
            return false;
        }
        if (this.client != null ? !this.client.equals(that.client) : that.client != null) {
            return false;
        }
        if (this.customFieldMap != null ? !this.customFieldMap.equals(that.customFieldMap) : that.customFieldMap != null) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.sysDrive != null ? !this.sysDrive.equals(that.sysDrive) : that.sysDrive != null) {
            return false;
        }
        if (this.sysRoot != null ? !this.sysRoot.equals(that.sysRoot) : that.sysRoot != null) {
            return false;
        }
        if (this.ticketFile != null ? !this.ticketFile.equals(that.ticketFile) : that.ticketFile != null) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) {
            return false;
        }
        if (this.urlJobView != null ? !this.urlJobView.equals(that.urlJobView) : that.urlJobView != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.environment != null ? this.environment.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.enabled ? 1 : 0);
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.client != null ? this.client.hashCode() : 0);
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        result = 31 * result + (this.ticketFile != null ? this.ticketFile.hashCode() : 0);
        result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
        result = 31 * result + (this.sysRoot != null ? this.sysRoot.hashCode() : 0);
        result = 31 * result + (this.sysDrive != null ? this.sysDrive.hashCode() : 0);
        result = 31 * result + (this.urlJobView != null ? this.urlJobView.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + this.authMethod;
        result = 31 * result + (this.customFieldMap != null ? this.customFieldMap.hashCode() : 0);
        return result;
    }
}

