/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.optionaldep;

import com.atlassian.jirafisheyeplugin.optionaldep.OptionalService;
import com.atlassian.util.concurrent.LazyReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class ServiceAccessor<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceAccessor.class);
    private final ApplicationContext applicationContext;
    private LazyReference<OptionalService<T>> serviceFactoryRef = new LazyReference<OptionalService<T>>(){

        protected OptionalService<T> create() throws Exception {
            try {
                Class serviceFactoryClass = ServiceAccessor.this.getServiceFactoryClass();
                if (serviceFactoryClass != null) {
                    return (OptionalService)ServiceAccessor.this.applicationContext.getAutowireCapableBeanFactory().createBean(serviceFactoryClass, 3, false);
                }
            }
            catch (Exception e) {
                log.debug("Could not create service factory", (Throwable)e);
            }
            return null;
        }
    };

    protected ServiceAccessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public T getService() {
        OptionalService serviceFactory = (OptionalService)this.serviceFactoryRef.get();
        return serviceFactory != null ? (T)serviceFactory.getService() : null;
    }

    protected abstract Class<? extends OptionalService<T>> getServiceFactoryClass();
}

