/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.optionaldep;

import com.google.common.base.Preconditions;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class OptionalService<T>
implements InitializingBean,
DisposableBean {
    private final Class<T> type;
    private final ServiceTracker tracker;

    public OptionalService(BundleContext bundleContext, Class<T> type) {
        this.tracker = new ServiceTracker(bundleContext, type.getName(), null);
        this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
    }

    public T getService() {
        return this.type.cast(this.tracker.getService());
    }

    public void afterPropertiesSet() {
        this.tracker.open();
    }

    public final void destroy() {
        this.tracker.close();
    }
}

