/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.operation;

import com.atlassian.jira.plugin.projectoperation.DefaultPluggableProjectOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssociatePerforceOperation
extends DefaultPluggableProjectOperation {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final PerforceConfigStore perforceConfigStore;
    private final PermissionManager permissionManager;
    private final SoftwareLicenseVerifier softwareLicenseVerifier;

    public AssociatePerforceOperation(PerforceConfigStore perforceConfigStore, PermissionManager permissionManager, SoftwareLicenseVerifier softwareLicenseVerifier) {
        this.perforceConfigStore = perforceConfigStore;
        this.permissionManager = permissionManager;
        this.softwareLicenseVerifier = softwareLicenseVerifier;
    }

    protected String getDescriptorHtml(Map params) {
        return this.descriptor.getHtml("view", params);
    }

    public boolean showOperation(Project project, ApplicationUser user) {
        if (!this.softwareLicenseVerifier.isAllowedForProjectAdmins(project)) {
            this.log.trace("Not showing AssociatePerforceOperation, because no software license or not a software project");
            return false;
        }
        return this.perforceConfigStore.getDefaultConfig() != null;
    }

    protected String getLabelHtml(Project project, ApplicationUser user) {
        return this.descriptor.getI18nBean().getText("perforce.associate.config");
    }

    protected String getContentHtml(Project project, ApplicationUser user) {
        MapBuilder params = MapBuilder.newBuilder((Object)"key", (Object)project.getKey(), (Object)"jfpTextutils", (Object)new JiraFisheyeEscapeTools());
        PerforceConfig p4config = this.perforceConfigStore.getConfig(project);
        if (p4config != null) {
            params.add((Object)"p4config", (Object)p4config);
        }
        params.add((Object)"hasEditPerms", (Object)this.permissionManager.hasPermission(0, user));
        return this.getDescriptorHtml(params.toMutableMap());
    }
}

