/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.operation;

import com.atlassian.jira.plugin.projectoperation.DefaultPluggableProjectOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jirafisheyeplugin.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.RepositoryPath;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.atlassian.jirafisheyeplugin.util.JiraFisheyeEscapeTools;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssociatePathOperation
extends DefaultPluggableProjectOperation {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final FishEyeManager fisheyeManager;
    private final PermissionManager permissionManager;
    private final RepositoryPathStore repositoryPathStore;
    private final SoftwareLicenseVerifier softwareLicenseVerifier;

    public AssociatePathOperation(FishEyeManager fisheyeManager, PermissionManager permissionManager, RepositoryPathStore repositoryPathStore, SoftwareLicenseVerifier softwareLicenseVerifier) {
        this.fisheyeManager = fisheyeManager;
        this.permissionManager = permissionManager;
        this.repositoryPathStore = repositoryPathStore;
        this.softwareLicenseVerifier = (SoftwareLicenseVerifier)Preconditions.checkNotNull((Object)softwareLicenseVerifier, (Object)"softwareLicenseVerifier");
    }

    protected String getDescriptorHtml(Map<String, Object> params) {
        return this.descriptor.getHtml("view", params);
    }

    public boolean showOperation(Project project, ApplicationUser user) {
        if (!this.softwareLicenseVerifier.isAllowedForProjectAdmins(project)) {
            this.log.trace("Not showing AssociatePerforceOperation, because no software license or not a software project");
            return false;
        }
        return this.fisheyeManager.hasValidConfig();
    }

    protected String getLabelHtml(Project project, ApplicationUser user) {
        return this.descriptor.getI18nBean().getText("fisheye.associate.path.repository.path");
    }

    protected String getContentHtml(Project project, ApplicationUser user) {
        MapBuilder params = MapBuilder.newBuilder((Object)"id", (Object)project.getId(), (Object)"jfpTextutils", (Object)new JiraFisheyeEscapeTools());
        String pKey = project.getKey();
        if (this.repositoryPathStore.hasRepositoryPath(pKey)) {
            RepositoryPath rp = this.repositoryPathStore.getRepositoryPath(pKey);
            params.add((Object)"browseUrl", (Object)rp.toBrowseUrl());
        }
        params.add((Object)"hasEditPerms", (Object)this.permissionManager.hasPermission(0, user));
        return this.getDescriptorHtml(params.toMutableMap());
    }
}

