/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.link.render;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.plugin.viewissue.issuelink.DefaultIssueLinkRenderer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jirafisheyeplugin.config.PermissionChecker;
import com.atlassian.jirafisheyeplugin.licensing.SoftwareLicenseVerifier;
import com.google.common.base.Preconditions;

public class CrucibleIssueLinkRenderer
extends DefaultIssueLinkRenderer {
    private final PermissionChecker permissionChecker;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueManager issueManager;
    private final SoftwareLicenseVerifier softwareLicenseVerifier;

    public CrucibleIssueLinkRenderer(PermissionChecker permissionChecker, JiraAuthenticationContext jiraAuthenticationContext, IssueManager issueManager, SoftwareLicenseVerifier softwareLicenseVerifier) {
        Preconditions.checkNotNull((Object)"SoftwareLicenseVerifier shouldn't be null", (Object)softwareLicenseVerifier);
        this.permissionChecker = permissionChecker;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issueManager = issueManager;
        this.softwareLicenseVerifier = softwareLicenseVerifier;
    }

    public boolean shouldDisplay(RemoteIssueLink remoteIssueLink) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        return this.isIssueDefined((Issue)issue) && this.isProjectDefined(issue.getProjectObject()) && this.softwareLicenseVerifier.isAllowedForSoftwareUsers(issue.getProjectObject(), user) && this.permissionChecker.hasVersionControlPermissions((Issue)issue, user);
    }

    private boolean isIssueDefined(Issue issue) {
        return issue != null;
    }

    private boolean isProjectDefined(Project projectObject) {
        return projectObject != null;
    }
}

