/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.licensing;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.software.api.project.SoftwareProjectTypeService;
import com.atlassian.jira.software.api.roles.LicenseService;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SoftwareLicenseVerifier {
    private final LicenseService licenseService;
    private final SoftwareProjectTypeService softwareProjectTypeService;

    public SoftwareLicenseVerifier(LicenseService licenseService, SoftwareProjectTypeService softwareProjectTypeService) {
        this.licenseService = licenseService;
        this.softwareProjectTypeService = softwareProjectTypeService;
    }

    public boolean isAllowedForSoftwareUsers(@Nonnull Project project, @Nullable ApplicationUser user) {
        return this.licenseService.hasSoftwareLicense() && this.licenseService.hasActiveSoftwareLicense() && !this.licenseService.isSoftwareUserLimitExceeded() && this.licenseService.isSoftwareUser(user) && this.softwareProjectTypeService.isSoftwareProject(project);
    }

    public boolean isAllowedForProjectAdmins(@Nonnull Project project) {
        return this.licenseService.hasSoftwareLicense() && this.licenseService.hasActiveSoftwareLicense() && this.softwareProjectTypeService.isSoftwareProject(project);
    }

    public boolean isAllowedForGlobalAdmins() {
        return this.licenseService.hasSoftwareLicense() && this.licenseService.hasActiveSoftwareLicense();
    }
}

