/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.gadgets;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSetManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.RepositoryPath;
import com.atlassian.jirafisheyeplugin.exceptions.OAuthNotAuthorisedException;
import com.atlassian.jirafisheyeplugin.gadgets.AbstractResource;
import com.atlassian.jirafisheyeplugin.gadgets.FishEyeGadgetValidationHelper;
import com.atlassian.jirafisheyeplugin.gadgets.ResourceUtil;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/fisheyerecentcommits")
@Produces(value={"application/json"})
public class FishEyeRecentCommitsResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(FishEyeRecentCommitsResource.class);
    private static final int DEFAULT_NUMBER_TO_SHOW = 10;
    private final ChangeSetManager changeSetManager;
    private final FishEyeRepositoryStore repositoryStore;
    private final FishEyeConfig fisheyeConfig;
    private final ApplicationProperties applicationProperties;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private FishEyeGadgetValidationHelper validationHelper;

    public FishEyeRecentCommitsResource(FishEyeRestApiManager fishEyeRestApiManager, ChangeSetManager changeSetManager, FishEyeRepositoryStore repositoryStore, FishEyeConfig fisheyeConfig, ApplicationProperties applicationProperties, WebResourceUrlProvider webResourceManager, FishEyeGadgetValidationHelper validationHelper) {
        super(fishEyeRestApiManager);
        this.changeSetManager = changeSetManager;
        this.repositoryStore = repositoryStore;
        this.fisheyeConfig = fisheyeConfig;
        this.applicationProperties = applicationProperties;
        this.webResourceUrlProvider = webResourceManager;
        this.validationHelper = validationHelper;
    }

    @GET
    @Path(value="/validate")
    public Response validate(@QueryParam(value="instance") String instanceIdStr, @QueryParam(value="rep") String rep, @QueryParam(value="numberToShow") String numberToShow) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validationHelper.validateFishEyeInstanceAndRepository(instanceIdStr, rep, errors);
        this.validationHelper.validateNumberOfChangesetsToShow(numberToShow, errors);
        return this.createValidationResponse(errors);
    }

    @GET
    @Path(value="/generate")
    public Response generate(@QueryParam(value="instance") String instanceIdStr, @QueryParam(value="rep") String rep, @QueryParam(value="path") @DefaultValue(value="/") String path, @QueryParam(value="numberToShow") String numberToShow) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.fisheyeConfig.isValid()) {
            ApplicationId fisheyeInstanceId;
            Integer num = ResourceUtil.parseInt(numberToShow, 10);
            try {
                fisheyeInstanceId = new ApplicationId(instanceIdStr);
            }
            catch (IllegalArgumentException iae) {
                return this.createErrorResponse(Collections.singleton(new ValidationError("feError", "gadget.fisheye.error.reconfigure.gadget.settings")));
            }
            FishEyeRepository repository = this.repositoryStore.getRepository(rep, fisheyeInstanceId);
            RepositoryPath repPath = new RepositoryPath(repository, path);
            List<ChangesetDO> changesetList = null;
            String jiraBaseUrl = this.applicationProperties.getString("jira.baseurl");
            try {
                changesetList = this.searchForChangesets(repPath, num, errors);
                if (errors.isEmpty()) {
                    ChangesetsDO changesets = new ChangesetsDO(jiraBaseUrl, this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.AUTO), repository.getInstance().getUrl(), repository.getName(), num, this.fisheyeConfig.getMaxProjectChangesets(), repository.getInstance().isCru(), changesetList);
                    return this.createOkResponse(changesets);
                }
                return this.createErrorResponse(errors);
            }
            catch (OAuthNotAuthorisedException e) {
                return this.createOauthNotAuthorisedResponse(e, jiraBaseUrl);
            }
        }
        return this.createErrorResponse(Collections.singletonList(new ValidationError("feError", "gadget.fisheye.error.not.configured")));
    }

    private List<ChangesetDO> searchForChangesets(RepositoryPath repositoryPath, Integer numberToDisplay, Collection<ValidationError> errors) throws OAuthNotAuthorisedException {
        ArrayList<ChangesetDO> changesets = new ArrayList<ChangesetDO>();
        try {
            List<Changeset> found = this.changeSetManager.searchForChangeSets(repositoryPath, numberToDisplay);
            for (Changeset cs : found) {
                changesets.add(new ChangesetDO(cs.getCsid(), cs.getAuthor(), JiraKeyUtils.linkBugKeys((String)TextUtils.plainTextToHtml((String)cs.getMsgPreview())), cs.getRevisionCount(), cs.getFullName()));
            }
        }
        catch (OAuthNotAuthorisedException oauth) {
            throw oauth;
        }
        catch (IOException e) {
            log.error("Error retrieving changesets from fisheye", (Throwable)e);
            errors.add(new ValidationError("feError", "gadget.fisheye.error.io"));
        }
        return changesets;
    }

    @XmlRootElement(name="changeset")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ChangesetDO {
        private String csid;
        private String author;
        private String fullName;
        private String message;
        private Integer fileCount;

        public ChangesetDO(String csid, String author, String message, Integer fileCount, String fullName) {
            this.csid = csid;
            this.author = author;
            this.message = message;
            this.fileCount = fileCount;
            this.fullName = fullName;
        }

        public ChangesetDO() {
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ChangesetsDO {
        private String baseUrl;
        private String staticResourcePrefix;
        private String fisheyeBaseUrl;
        private String fisheyeRepository;
        private Integer maxChangesets;
        private Integer maxDays;
        private Boolean isCrucible;
        private List<ChangesetDO> changesets;

        public ChangesetsDO(String baseUrl, String staticResourcePrefix, String fisheyeBaseUrl, String fisheyeRepository, Integer maxChangesets, Integer maxDays, Boolean crucible, List<ChangesetDO> changesets) {
            this.baseUrl = baseUrl;
            this.fisheyeBaseUrl = fisheyeBaseUrl;
            this.fisheyeRepository = fisheyeRepository;
            this.maxChangesets = maxChangesets;
            this.maxDays = maxDays;
            this.isCrucible = crucible;
            this.changesets = changesets;
            this.staticResourcePrefix = staticResourcePrefix;
        }

        public ChangesetsDO() {
        }
    }
}

