/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.gadgets;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.gadgets.ResourceUtil;
import java.util.Collection;

public class FishEyeGadgetValidationHelper {
    private static final int MIN_CHANGESETS = 1;
    private static final int MAX_CHANGESETS = 100;
    private final FishEyeInstanceStore instanceStore;
    private final FishEyeRepositoryStore repositoryStore;

    public FishEyeGadgetValidationHelper(FishEyeInstanceStore instanceStore, FishEyeRepositoryStore repositoryStore) {
        this.instanceStore = instanceStore;
        this.repositoryStore = repositoryStore;
    }

    public void validateFishEyeInstanceAndRepository(String instanceIdStr, String rep, Collection<ValidationError> errors) {
        ApplicationId id = null;
        try {
            id = this.toApplicationLinkId(instanceIdStr);
        }
        catch (IllegalArgumentException iae) {
            errors.add(new ValidationError("instanceId", "gadget.fisheye.error.reconfigure.gadget.settings"));
            return;
        }
        if (id == null) {
            errors.add(new ValidationError("instanceId", "gadget.fisheye.error.need.specify.instance"));
        } else if (this.instanceStore.getFishEyeInstance(id) == null) {
            errors.add(new ValidationError("instanceId", "gadget.fisheye.error.instance.non.existent"));
        } else if (ResourceUtil.nullOrWhitespace(rep)) {
            errors.add(new ValidationError("rep", "gadget.fisheye.error.need.specify.rep"));
        } else if (this.repositoryStore.getRepository(rep, id) == null) {
            errors.add(new ValidationError("rep", "gadget.fisheye.error.rep.non.existent"));
        }
    }

    private ApplicationId toApplicationLinkId(String instanceIdStr) {
        return instanceIdStr == null ? null : new ApplicationId(instanceIdStr);
    }

    public void validateCrucibleInstance(String instanceIdStr, Collection<ValidationError> errors) {
        ApplicationId id = null;
        try {
            id = this.toApplicationLinkId(instanceIdStr);
        }
        catch (IllegalArgumentException iae) {
            errors.add(new ValidationError("instanceId", "gadget.fisheye.error.reconfigure.gadget.settings"));
            return;
        }
        if (id == null) {
            errors.add(new ValidationError("instanceId", "gadget.crucible.error.need.specify.instance"));
        } else if (this.instanceStore.getFishEyeInstance(id) == null) {
            errors.add(new ValidationError("instanceId", "gadget.crucible.error.instance.non.existent"));
        }
    }

    public void validateCrucibleProjectKey(String projectKey, Collection<ValidationError> errors) {
        if (ResourceUtil.nullOrWhitespace(projectKey)) {
            errors.add(new ValidationError("project", "gadget.crucible.error.need.specify.project"));
        }
    }

    public void validateNumberOfChangesetsToShow(String numberToShow, Collection<ValidationError> errors) {
        Integer n = ResourceUtil.parseInt(numberToShow, null);
        if (n == null || n < 1 || n > 100) {
            errors.add(new ValidationError("numberToShow", "gadget.fisheye.error.invalid.number.to.show"));
        }
    }
}

