/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.gadgets;

import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.gadgets.AbstractResource;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/fisheyeconfig")
@Produces(value={"application/json"})
public class FishEyeConfigResource
extends AbstractResource {
    private final FishEyeInstanceStore instanceStore;

    public FishEyeConfigResource(FishEyeRestApiManager fishEyeRestApiManager, FishEyeInstanceStore instanceStore) {
        super(fishEyeRestApiManager);
        this.instanceStore = instanceStore;
    }

    @GET
    @Path(value="/instances")
    public Response getInstances() {
        ArrayList<MapEntry> instances = new ArrayList<MapEntry>();
        for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
            String id = instance.getApplicationId().get();
            instances.add(new MapEntry(id, instance.getUrl()));
        }
        return this.createOkResponse(new FishEyeInstances(instances));
    }

    @XmlRootElement
    public static class MapEntry {
        @XmlElement
        private final String value;
        @XmlElement
        private final String label;

        private MapEntry() {
            this.value = null;
            this.label = null;
        }

        public MapEntry(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getKey() {
            return this.value;
        }

        public String getValue() {
            return this.label;
        }
    }

    @XmlRootElement
    public static class FishEyeInstances {
        @XmlElement
        private Collection<MapEntry> instances;

        public FishEyeInstances(Collection<MapEntry> instances) {
            this.instances = instances;
        }

        public FishEyeInstances() {
        }
    }
}

