/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.gadgets;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.exceptions.OAuthNotAuthorisedException;
import com.atlassian.jirafisheyeplugin.gadgets.AbstractResource;
import com.atlassian.jirafisheyeplugin.gadgets.FishEyeGadgetValidationHelper;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import java.io.IOException;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/cruciblechart")
@Produces(value={"application/json"})
public class CrucibleChartResource
extends AbstractResource {
    private final ApplicationProperties applicationProperties;
    private final FishEyeInstanceStore instanceStore;
    private final FishEyeGadgetValidationHelper validationHelper;

    public CrucibleChartResource(FishEyeRestApiManager fishEyeRestApiManager, ApplicationProperties applicationProperties, FishEyeInstanceStore instanceStore, FishEyeGadgetValidationHelper validationHelper) {
        super(fishEyeRestApiManager);
        this.applicationProperties = applicationProperties;
        this.instanceStore = instanceStore;
        this.validationHelper = validationHelper;
    }

    @GET
    @Path(value="/validate")
    public Response validate(@QueryParam(value="instance") String instanceIdStr, @QueryParam(value="project") String projectKey) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validationHelper.validateCrucibleInstance(instanceIdStr, errors);
        this.validationHelper.validateCrucibleProjectKey(projectKey, errors);
        return this.createValidationResponse(errors);
    }

    @GET
    @Path(value="/generate")
    public Response generate(@QueryParam(value="instance") String instanceId) {
        ApplicationId id;
        try {
            id = new ApplicationId(instanceId);
        }
        catch (IllegalArgumentException iae) {
            return this.createOkResponse(new CrucibleChartData(null, "gadget.fisheye.error.reconfigure.gadget.settings"));
        }
        FishEyeInstance feInst = this.instanceStore.getFishEyeInstance(id);
        if (feInst == null) {
            return this.createOkResponse(new CrucibleChartData(null, "gadget.crucible.error.instance.non.existent"));
        }
        try {
            this.checkAvailability(feInst);
        }
        catch (OAuthNotAuthorisedException oauth) {
            return this.createOauthNotAuthorisedResponse(oauth, this.applicationProperties.getString("jira.baseurl"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.createOkResponse(new CrucibleChartData(feInst.getUrl(), null));
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class CrucibleChartData {
        private String fisheyeBaseUrl;
        private String errorKey;

        public CrucibleChartData(String fisheyeBaseUrl, String errorKey) {
            this.fisheyeBaseUrl = fisheyeBaseUrl;
            this.errorKey = errorKey;
        }

        public CrucibleChartData() {
        }
    }
}

