/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.gadgets;

import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.model.errors.ValidationError;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ServerInfo;
import com.atlassian.jirafisheyeplugin.exceptions.OAuthNotAuthorisedException;
import com.atlassian.jirafisheyeplugin.gadgets.OauthNotAuthorisedResponse;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import com.atlassian.jirafisheyeplugin.rest.command.RestCommandFactory;
import com.atlassian.jirafisheyeplugin.rest.response.FishEyeDocumentHolder;
import com.atlassian.jirafisheyeplugin.rest.response.ResponseParser;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;

public class AbstractResource {
    private final FishEyeRestApiManager fishEyeRestApiManager;

    public AbstractResource(FishEyeRestApiManager fishEyeRestApiManager) {
        this.fishEyeRestApiManager = fishEyeRestApiManager;
    }

    protected Response createErrorResponse(Collection<ValidationError> errors) {
        return Response.status((int)400).entity((Object)ErrorCollection.Builder.newBuilder(errors).build()).cacheControl(CacheControl.NO_CACHE).build();
    }

    protected Response createValidationResponse(Collection<ValidationError> errors) {
        if (errors.isEmpty()) {
            return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
        }
        return this.createErrorResponse(errors);
    }

    protected Response createOkResponse(Object entity) {
        return Response.ok((Object)entity).cacheControl(CacheControl.NO_CACHE).build();
    }

    protected void checkAvailability(FishEyeInstance feInst) throws IOException, OAuthNotAuthorisedException {
        this.fishEyeRestApiManager.callFisheye(feInst, RestCommandFactory.serverInfo(), new ResponseParser(){

            public List parse(FishEyeDocumentHolder doc) throws IOException {
                return Lists.newArrayList((Object[])new ServerInfo[]{ServerInfo.fromDocument(doc.getDoc())});
            }
        });
    }

    protected Response createOauthNotAuthorisedResponse(OAuthNotAuthorisedException e, String jiraBaseUrl) {
        return Response.ok((Object)new OauthNotAuthorisedResponse(e, jiraBaseUrl)).cacheControl(CacheControl.NO_CACHE).build();
    }
}

