/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.workflow.condition;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.workflow.condition.AbstractJiraCondition;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSetManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSets;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnreviewedCodeCondition
extends AbstractJiraCondition {
    private static final Logger log = LoggerFactory.getLogger(UnreviewedCodeCondition.class);

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) {
        Issue issue = (Issue)transientVars.get("originalissueobject");
        ChangeSets changesets = this.getChangeSetManager().getChangesetsForIssue(issue);
        ReviewManager reviewManager = this.getReviewManager();
        for (Changeset cs : changesets.getChangesets()) {
            try {
                List<Review> revs = cs.isReviewsInitialised() ? cs.getReviews() : reviewManager.getReviewsForChangeset(issue.getProjectObject().getKey(), cs.getCsid(), cs.getRep());
                if (!revs.isEmpty()) continue;
                return false;
            }
            catch (IOException e) {
                log.error("Error retrieving reviews for UnreviewedCodeCondition (csid: " + cs.getCsid() + "):", (Throwable)e);
            }
        }
        return true;
    }

    protected ReviewManager getReviewManager() {
        return (ReviewManager)ComponentManager.getOSGiComponentInstanceOfType(ReviewManager.class);
    }

    protected ChangeSetManager getChangeSetManager() {
        return (ChangeSetManager)ComponentManager.getOSGiComponentInstanceOfType(ChangeSetManager.class);
    }
}

