/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.workflow.condition;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.workflow.condition.AbstractJiraCondition;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSetManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSets;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.SourceErrorReport;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeCommittedCondition
extends AbstractJiraCondition {
    private static Logger log = LoggerFactory.getLogger(CodeCommittedCondition.class);
    public static final String IS_CODE_COMMITTED_KEY = "isCodeCommitted";

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) {
        boolean isCodeCommitted;
        String isCodeCommittedString;
        Issue issue = (Issue)transientVars.get("originalissueobject");
        ChangeSets changesets = this.getChangeSetManager().getChangesetsForIssue(issue);
        if (changesets.hasErrors()) {
            for (SourceErrorReport err : changesets.getErrors()) {
                log.error("Error encountered whilst determining is " + issue.getKey() + " passes CodeCommittedCondition: " + err.toString());
            }
        }
        if ((isCodeCommittedString = (String)args.get(IS_CODE_COMMITTED_KEY)) == null) {
            log.error("Could not resolve CodeCommittedCondition argument 'isCodeCommitted' for issue '" + issue.getKey() + "' defaulting to 'false'");
            isCodeCommitted = false;
        } else {
            isCodeCommitted = Boolean.valueOf(isCodeCommittedString);
        }
        List<Changeset> csList = changesets.getChangesets();
        return isCodeCommitted ^ (csList == null || csList.isEmpty());
    }

    protected ChangeSetManager getChangeSetManager() {
        return (ChangeSetManager)ComponentManager.getOSGiComponentInstanceOfType(ChangeSetManager.class);
    }
}

