/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.fisheye;

import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.security.xml.libs.SecureDom4jFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public final class ServerInfo {
    private boolean isCrucible;
    private boolean isCrucibleStandalone;
    private int version;
    private static final Pattern STARTS_NUMERICAL_PATTERN = Pattern.compile("^(\\d+).*");

    public static ServerInfo fisheyeAndCrucible() {
        return new ServerInfo(true, false);
    }

    public static ServerInfo crucibleStandalone() {
        return new ServerInfo(false, true);
    }

    public static ServerInfo fromXML(InputStream serverResponse) throws ResponseException {
        try {
            SAXReader xmlReader = SecureDom4jFactory.newSaxReader();
            Document document = xmlReader.read(serverResponse);
            return new ServerInfo(document);
        }
        catch (Exception e) {
            throw new ResponseException(String.format("Error parsing response [%s]", serverResponse), (Throwable)e);
        }
    }

    public static ServerInfo fromDocument(Document document) {
        return new ServerInfo(document);
    }

    private ServerInfo(boolean isCrucible, boolean isCrucibleStandalone) {
        this.isCrucible = isCrucible;
        this.isCrucibleStandalone = isCrucibleStandalone;
    }

    private ServerInfo(Document document) {
        this.setProperties(document);
    }

    public boolean isCrucible() {
        return this.isCrucible;
    }

    public boolean isCrucibleStandalone() {
        return this.isCrucibleStandalone;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return "ServerInfo{isCrucible=" + this.isCrucible + ", isCrucibleStandalone=" + this.isCrucibleStandalone + '}';
    }

    /*
     * WARNING - void declaration
     */
    private void setProperties(Document document) {
        void var8_11;
        String crucible = document.selectSingleNode("/serverInfo/isCrucible").getStringValue();
        this.isCrucible = Boolean.parseBoolean(crucible);
        String version = document.selectSingleNode("/serverInfo/version/releaseNumber").getStringValue();
        String[] components = version.split("[\\.\\-]");
        List<Object> list = Lists.newArrayListWithCapacity((int)components.length);
        String[] stringArray = components;
        int n = stringArray.length;
        boolean bl = false;
        while (var8_11 < n) {
            String component = stringArray[var8_11];
            try {
                list.add(Integer.valueOf(component));
            }
            catch (NumberFormatException e) {
                Matcher matcher = STARTS_NUMERICAL_PATTERN.matcher(component);
                if (!matcher.matches()) break;
                list.add(Integer.valueOf(matcher.group(1)));
                break;
            }
            ++var8_11;
        }
        list = this.normalise((List<Integer>)list);
        int versionNumber = 0;
        for (Integer n2 : list) {
            versionNumber = versionNumber * 1000 + n2;
        }
        this.version = versionNumber;
    }

    private List<Integer> normalise(List<Integer> list) {
        while (list.size() < 3) {
            list.add(0);
        }
        return ImmutableList.copyOf(list);
    }
}

