/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.fisheye;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.SourceErrorReport;
import java.net.URI;

public class OAuthErrorReport
extends SourceErrorReport
implements AuthorisationURIGenerator {
    private final AuthorisationURIGenerator uriGenerator;
    private final ApplicationId applicationId;
    private final boolean hideable;

    public OAuthErrorReport(FishEyeRepository repository, AuthorisationURIGenerator authorisationURIGenerator, String errorMessage) {
        super(repository, errorMessage);
        this.uriGenerator = authorisationURIGenerator;
        this.applicationId = repository.getInstance().getApplicationId();
        this.hideable = true;
    }

    public OAuthErrorReport(FishEyeInstance instance, AuthorisationURIGenerator authorisationURIGenerator, String errorMessage) {
        super(instance, errorMessage);
        this.applicationId = instance.getApplicationId();
        this.uriGenerator = authorisationURIGenerator;
        this.hideable = true;
    }

    public OAuthErrorReport(ApplicationLink applicationLink, AuthorisationURIGenerator uriGenerator, String errorMessage) {
        super(applicationLink, errorMessage);
        this.uriGenerator = uriGenerator;
        this.applicationId = applicationLink.getId();
        this.hideable = applicationLink.getType() instanceof FishEyeCrucibleApplicationType;
    }

    public URI getAuthorisationURI(URI callback) {
        return this.uriGenerator.getAuthorisationURI(callback);
    }

    public URI getAuthorisationURI() {
        return this.uriGenerator.getAuthorisationURI();
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public boolean isHideable() {
        return this.hideable;
    }
}

