/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.fisheye;

import com.atlassian.jira.project.Project;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FishEyeRepositoryImpl
implements FishEyeRepository,
Comparable<FishEyeRepository> {
    private final FishEyeInstance fisheyeInstance;
    private final String name;
    private final Collection<Long> mappedProjectIds;

    public FishEyeRepositoryImpl(FishEyeInstance fisheyeInstance, String name, Collection<Long> mappedProjectIds) {
        this.fisheyeInstance = fisheyeInstance;
        this.name = name;
        this.mappedProjectIds = new HashSet<Long>();
        if (mappedProjectIds != null) {
            this.mappedProjectIds.addAll(mappedProjectIds);
        }
    }

    @Override
    public FishEyeInstance getInstance() {
        return this.fisheyeInstance;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Long> getMappedProjectIds() {
        return new TreeSet<Long>(this.mappedProjectIds);
    }

    @Override
    public void map(Project jiraProject) {
        if (jiraProject != null) {
            this.mappedProjectIds.add(jiraProject.getId());
        }
    }

    @Override
    public void unMap(Project jiraProject) {
        if (jiraProject != null) {
            this.mappedProjectIds.remove(jiraProject.getId());
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FishEyeRepositoryImpl)) {
            return false;
        }
        FishEyeRepositoryImpl that = (FishEyeRepositoryImpl)o;
        return this.fisheyeInstance.equals(that.fisheyeInstance) && this.mappedProjectIds.equals(that.mappedProjectIds) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.fisheyeInstance.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.mappedProjectIds.hashCode();
        return result;
    }

    @Override
    public int compareTo(FishEyeRepository o) {
        if (o == null) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }
}

