/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.fisheye;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSupportedApplicationLinkService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.Refreshable;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.domain.crucible.CrucibleProject;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.RepositoryPath;
import com.atlassian.jirafisheyeplugin.exceptions.OAuthNotAuthorisedException;
import com.atlassian.jirafisheyeplugin.optionaldep.DevStatusSupportedAppLinksServiceAccessor;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import com.atlassian.jirafisheyeplugin.rest.command.RestCommandFactory;
import com.atlassian.jirafisheyeplugin.rest.response.MultipleStringParser;
import com.atlassian.jirafisheyeplugin.rest.response.ProjectParser;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FishEyeManagerImpl
implements FishEyeManager,
InitializingBean,
Refreshable {
    private static final Logger log = LoggerFactory.getLogger(FishEyeManagerImpl.class);
    private static final long THRESHOLD = Long.valueOf(System.getProperty("jirafisheye.crucible.projects.list.refresh.frequency", Long.toString(60000L)));
    @VisibleForTesting
    static final String FEATURE_ENABLED = "jira.plugin.fisheye.tab.enabled";
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final FishEyeRestApiManager apiManager;
    private final FishEyeInstanceStore instanceStore;
    private final FishEyeRepositoryStore repositoryStore;
    private final RepositoryPathStore repositoryPathStore;
    private final CrucibleProjectStore crucibleProjectStore;
    private final RefreshManager refreshManager;
    private final FeatureManager featureManager;
    private final FishEyeConfig config;
    private final DevStatusSupportedAppLinksServiceAccessor devStatusSupportedAppLinksServiceAccessor;
    @ClusterSafe(value="Locally managed cache")
    private Map<FishEyeInstance, List<CrucibleProject>> crucibleProjects = new HashMap<FishEyeInstance, List<CrucibleProject>>();
    @ClusterSafe(value="Locally managed cache")
    private Cache<FishEyeInstance, Long> lastChecked = CacheBuilder.newBuilder().expireAfterWrite(THRESHOLD, TimeUnit.MILLISECONDS).build();

    public FishEyeManagerImpl(PermissionManager permissionManager, IssueManager issueManager, FishEyeRestApiManager apiManager, FishEyeInstanceStore instanceStore, FishEyeRepositoryStore repositoryStore, FishEyeConfig config, RepositoryPathStore repositoryPathStore, CrucibleProjectStore crucibleProjectStore, RefreshManager refreshManager, FeatureManager featureManager, DevStatusSupportedAppLinksServiceAccessor devStatusSupportedAppLinksServiceAccessor) {
        this.permissionManager = permissionManager;
        this.issueManager = issueManager;
        this.apiManager = apiManager;
        this.instanceStore = instanceStore;
        this.repositoryStore = repositoryStore;
        this.config = config;
        this.repositoryPathStore = repositoryPathStore;
        this.crucibleProjectStore = crucibleProjectStore;
        this.refreshManager = refreshManager;
        this.featureManager = featureManager;
        this.devStatusSupportedAppLinksServiceAccessor = devStatusSupportedAppLinksServiceAccessor;
    }

    @Override
    public void refreshConfig() {
        this.refreshManager.refreshAll();
    }

    @Override
    public Collection<String> getRepositories(ApplicationId fisheyeInstanceId) throws IOException {
        return this.getRepositories(this.instanceStore.getFishEyeInstance(fisheyeInstanceId));
    }

    @Override
    public List<String> getRepositories(FishEyeInstance fisheyeInstance) throws IOException {
        List<String> reps = this.apiManager.callFisheye(fisheyeInstance, RestCommandFactory.repositories(), MultipleStringParser.PARSER);
        if (reps.isEmpty()) {
            log.warn("Found no repositories in FishEye instance at '" + fisheyeInstance.getUrl() + "'");
        }
        return reps;
    }

    @Override
    public Collection<FishEyeRepository> getRepositoriesForProject(String projectKey) {
        Set<FishEyeRepository> repos = this.repositoryStore.getRepositories(projectKey);
        RepositoryPath path = this.repositoryPathStore.getRepositoryPath(projectKey);
        if (path != null) {
            repos.add(path.getRep());
        }
        return repos;
    }

    @Override
    public Collection<FishEyeInstance> getInstancesForProject(String projectKey) {
        HashSet<FishEyeInstance> instances = new HashSet<FishEyeInstance>();
        Collection<FishEyeRepository> reps = this.getRepositoriesForProject(projectKey);
        for (FishEyeRepository repository : reps) {
            instances.add(repository.getInstance());
        }
        instances.addAll(this.getCrucibleStandaloneInstances());
        return instances;
    }

    @Override
    public Collection<FishEyeInstance> getCrucibleStandaloneInstances() {
        return this.instanceStore.getCrucibleStandaloneInstances();
    }

    @Override
    public boolean existsCrucibleStandaloneInstances() {
        return !this.getCrucibleStandaloneInstances().isEmpty();
    }

    @Override
    public boolean filterByBrowseIssuePermission(Collection<Changeset> changesets, ApplicationUser user) {
        boolean hasRemoved = false;
        Iterator<Changeset> csIterator = changesets.iterator();
        block0: while (csIterator.hasNext()) {
            Changeset cs = csIterator.next();
            HashSet<String> issueKeys = new HashSet<String>(this.getIssueKeysFromString(cs.getMsg()));
            for (String key : issueKeys) {
                MutableIssue issue = this.issueManager.getIssueObject(key);
                if (issue == null) {
                    log.debug("Could not find issue with key '" + key + "' parsed from changeset log (csid=" + cs.getCsid() + ").");
                    continue;
                }
                if (this.permissionManager.hasPermission(10, (Issue)issue, user)) continue;
                csIterator.remove();
                hasRemoved = true;
                continue block0;
            }
        }
        return hasRemoved;
    }

    protected Collection<String> getIssueKeysFromString(String string) {
        return JiraKeyUtils.getIssueKeysFromString((String)string);
    }

    @Override
    public boolean hasNoSummary() {
        DevStatusSupportedApplicationLinkService devStatusSupportedAppLinksService = this.getDevStatusSupportedApplicationLinkService();
        return this.featureManager.isEnabled(FEATURE_ENABLED) || devStatusSupportedAppLinksService == null || !devStatusSupportedAppLinksService.hasApplicationTypeFull2LOSupport(FishEyeCrucibleApplicationType.class);
    }

    protected DevStatusSupportedApplicationLinkService getDevStatusSupportedApplicationLinkService() {
        return (DevStatusSupportedApplicationLinkService)this.devStatusSupportedAppLinksServiceAccessor.getService();
    }

    @Override
    public boolean hasValidConfig() {
        return this.config != null && this.config.isValid();
    }

    private void refreshCrucibleProjects() {
        HashMap<String, String> cruProjectKey2baseUrlMap = new HashMap<String, String>();
        for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
            if (!instance.isCru()) continue;
            try {
                HashSet existing = Sets.newHashSet(this.crucibleProjectStore.getCrucibleProjectKeys(instance.getApplicationId()));
                HashSet retrieved = Sets.newHashSet((Iterable)Collections2.transform(this.getProjectsImpl(instance), (Function)new Function<CrucibleProject, String>(){

                    public String apply(CrucibleProject from) {
                        return from.getKey();
                    }
                }));
                Sets.SetView merged = Sets.union((Set)retrieved, (Set)existing);
                for (String cruProjectkey : merged) {
                    cruProjectKey2baseUrlMap.put(cruProjectkey, instance.getUrl());
                }
                this.crucibleProjectStore.setCrucibleProjectKeys((Collection<String>)merged, instance.getApplicationId());
                this.config.setCrucibleProjectToUrlMappings(cruProjectKey2baseUrlMap);
            }
            catch (OAuthNotAuthorisedException e) {
                log.debug("OAuth not authorised exception encountered resolving Crucible projects for " + instance.getUrl());
            }
            catch (IOException e) {
                log.warn("Error encountered resolving Crucible projects for " + instance.getUrl(), (Throwable)e);
            }
        }
    }

    private void updateInstanceRepositories() {
        for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
            if (instance.isCruStandalone()) continue;
            try {
                HashSet retrieved = Sets.newHashSet(this.getRepositories(instance));
                HashSet existing = Sets.newHashSet((Iterable)Collections2.transform(this.repositoryStore.getRepositoriesForInstance(instance.getApplicationId()), (Function)new Function<FishEyeRepository, String>(){

                    public String apply(FishEyeRepository from) {
                        return from.getName();
                    }
                }));
                retrieved.removeAll(existing);
                if (retrieved.isEmpty()) continue;
                log.debug("Found new repository(s) for '" + instance.getUrl() + "': " + retrieved);
                this.repositoryStore.addRepositories(retrieved, instance.getApplicationId());
            }
            catch (OAuthNotAuthorisedException e) {
                log.debug("OAuth not authorised exception encountered retrieving FishEye repositories for " + instance.getUrl());
            }
            catch (IOException e) {
                log.warn("Error retrieving repositories for '" + instance.getUrl() + "'", (Throwable)e);
            }
        }
    }

    @Override
    public void refresh() {
        this.updateInstanceRepositories();
        this.refreshCrucibleProjects();
    }

    @Override
    public int order() {
        return 70;
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshManager.registerRefreshable(this);
    }

    private Object doQuery(Query query, FishEyeRepository rep) throws IOException {
        try {
            return query.doQuery(rep, true);
        }
        catch (IOException e) {
            return query.doQuery(rep, false);
        }
    }

    @Override
    public boolean isCrucibleEnabled() {
        return this.config.isCrucibleEnabled();
    }

    @Override
    public boolean isCrucibleEnabled(Project context) {
        Collection<FishEyeInstance> instances = this.getInstancesForProject(context.getKey());
        for (FishEyeInstance instance : instances) {
            if (!instance.isCru()) continue;
            return true;
        }
        if (instances.isEmpty()) {
            for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
                if (!instance.isCru() || !instance.isCrossRepoCapable(this.apiManager)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAssociatedWithFishEye(String projectKey) {
        boolean repositoriesIsEmpty = this.repositoryStore.getRepositories(projectKey).isEmpty();
        if (!repositoriesIsEmpty) {
            return true;
        }
        for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
            if (!instance.isCrossRepoCapable(this.apiManager)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAssociatedWithCrucible(String projectKey) {
        String timerKey = "FisheyeManagerImpl.isAssociatedWithCrucible()";
        try {
            UtilTimerStack.push((String)"FisheyeManagerImpl.isAssociatedWithCrucible()");
            for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
                if (this.crucibleProjectStore.getDefaultCrucibleProjectKey(projectKey, instance.getApplicationId()) != null) {
                    boolean bl = true;
                    return bl;
                }
                Collection<String> crucibleProjectKeys = this.crucibleProjectStore.getCrucibleProjectKeys(instance.getApplicationId());
                if (!crucibleProjectKeys.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                if (!instance.isCrossRepoCapable(this.apiManager)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            UtilTimerStack.pop((String)"FisheyeManagerImpl.isAssociatedWithCrucible()");
        }
    }

    @Override
    public List<CrucibleProject> getProjects(ApplicationId fisheyeInstanceId) throws IOException {
        return this.getProjects(this.instanceStore.getFishEyeInstance(fisheyeInstanceId));
    }

    @Override
    public List<CrucibleProject> getProjects(FishEyeInstance instance) throws IOException {
        boolean notInCache = !this.crucibleProjects.containsKey(instance);
        boolean cacheExpired = this.isCacheExpired(instance, false);
        if (notInCache || cacheExpired) {
            log.debug(String.format("crucible project list cache miss on instance [%s] : !crucibleProjects.containsKey(instance)=[%s] isCacheExpired(instance)=[%s]", instance, notInCache, cacheExpired));
            this.crucibleProjects.put(instance, this.getProjectsImpl(instance));
            this.isCacheExpired(instance, true);
            return this.crucibleProjects.get(instance);
        }
        log.debug(String.format("crucible project list cache hit on instance [%s] : !crucibleProjects.containsKey(instance)=[%s] isCacheExpired(instance)=[%s]", instance, notInCache, cacheExpired));
        return this.crucibleProjects.get(instance);
    }

    private boolean isCacheExpired(FishEyeInstance instance, boolean updateTime) {
        Long lastCheck = (Long)this.lastChecked.getIfPresent((Object)instance);
        long t = System.currentTimeMillis();
        if (lastCheck == null || t - lastCheck > THRESHOLD) {
            if (updateTime) {
                this.lastChecked.put((Object)instance, (Object)t);
            }
            return true;
        }
        return false;
    }

    private List<CrucibleProject> getProjectsImpl(FishEyeInstance instance) throws IOException {
        if (instance.isCru()) {
            return this.apiManager.callFisheye(instance, RestCommandFactory.projects(), ProjectParser.PARSER);
        }
        return Collections.emptyList();
    }

    @Override
    public FishEyeConfig getConfig() {
        return this.config;
    }

    @Override
    public String resolveFishEyeBaseUrl(Collection<FishEyeRepository> reps) {
        String defaultUrl = this.instanceStore.getDefaultFishEyeInstance().getUrl();
        if (reps.isEmpty()) {
            return defaultUrl;
        }
        String url = null;
        for (FishEyeRepository rep : reps) {
            if (url != null && !url.equals(rep.getInstance().getUrl())) {
                url = defaultUrl;
                break;
            }
            url = rep.getInstance().getUrl();
        }
        return url;
    }

    private static interface Query {
        public Object doQuery(FishEyeRepository var1, boolean var2) throws IOException;
    }
}

