/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.fisheye;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jirafisheyeplugin.config.SearchConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import com.atlassian.jirafisheyeplugin.rest.command.RestCommandFactory;
import com.atlassian.jirafisheyeplugin.rest.response.ChangesetDataFeResponseParser;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FishEyeInstanceImpl
implements FishEyeInstance {
    private final String name;
    private final boolean isCru;
    private final boolean isCruStandalone;
    private final String url;
    private final String apiUrl;
    private final Charset charset;
    private final int socketTimeout;
    private final int connectionTimeout;
    private final ApplicationId applicationId;
    private final boolean hasBeenInitialised;
    private int version = -1;
    private long versionTimestamp = 0L;
    private static long VERSION_TIMEOUT = 600000L;
    private Boolean crossRepoCapable;
    private long crossRepoCapabilityTimestamp = 0L;
    private static final SearchConfig SEARCH_CONFIG = new SearchConfig(null, 0, 0, false, false, false, 0);

    public FishEyeInstanceImpl(String name, boolean isCru, boolean isCruStandalone, String url, String apiUrl, Charset charset, int socketTimeout, int connectionTimeout, ApplicationId applicationId, boolean hasBeenInitialised) {
        this.name = name;
        this.isCru = isCru;
        this.isCruStandalone = isCruStandalone;
        this.url = this.normalise(url);
        this.apiUrl = this.normalise(apiUrl);
        this.charset = charset;
        this.socketTimeout = socketTimeout;
        this.connectionTimeout = connectionTimeout;
        this.applicationId = applicationId;
        this.hasBeenInitialised = hasBeenInitialised;
    }

    private String normalise(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCru() {
        return this.isCru;
    }

    @Override
    public boolean isCruStandalone() {
        return this.isCruStandalone;
    }

    @Override
    public int getVersion(FishEyeInstanceManager fishEyeInstanceManager) {
        long now = System.currentTimeMillis();
        long timeSinceLastVersionCheck = now - this.versionTimestamp;
        if (this.version == -1 || timeSinceLastVersionCheck > VERSION_TIMEOUT) {
            this.version = fishEyeInstanceManager.getVersionNumber(this);
            this.versionTimestamp = now;
        }
        return this.version;
    }

    @Override
    public boolean isCrossRepoCapable(FishEyeRestApiManager apiManager) {
        long now = System.currentTimeMillis();
        long timeSinceLastVersionCheck = now - this.crossRepoCapabilityTimestamp;
        if (this.crossRepoCapable == null || timeSinceLastVersionCheck > VERSION_TIMEOUT) {
            try {
                apiManager.callFisheye(this, RestCommandFactory.listChangesets(this, "", Collections.emptySet(), SEARCH_CONFIG), new ChangesetDataFeResponseParser((FishEyeRepository)null));
            }
            catch (IOException e) {
                this.crossRepoCapable = !e.getMessage().contains("404");
            }
            this.crossRepoCapabilityTimestamp = now;
        }
        return this.crossRepoCapable == null ? true : this.crossRepoCapable;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Override
    public String getEffectiveApiUrl() {
        return this.apiUrl == null ? this.url : this.apiUrl;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public boolean isHasBeenInitialised() {
        return this.hasBeenInitialised;
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FishEyeInstanceImpl that = (FishEyeInstanceImpl)o;
        return !(this.applicationId != null ? !this.applicationId.equals((Object)that.applicationId) : that.applicationId != null);
    }

    public int hashCode() {
        return this.applicationId != null ? this.applicationId.hashCode() : 0;
    }
}

