/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.fisheye;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.comparator.KeyComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.fisheye.AbstractFishEyeRemoteObject;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Changeset
extends AbstractFishEyeRemoteObject {
    private static final int MSG_PREVIEW_LENGTH = 200;
    private static final String MSG_PREVIEW_NEWLINE_REPLACEMENT = " ";
    private static final String MSG_PREVIEW_ELLIPSIS = "...";
    private String csid;
    private String rep;
    private String author;
    private Date date;
    private String msg;
    private List<Revision> revisions;
    private int incomplete = 0;
    private ApplicationUser user;
    private String associatedProjectKey;
    private Set<String> p4JobsFixed;
    private final String branch;
    private List<Review> reviews;
    private String oldKey = null;

    public Changeset(String rep, String csid, String url, boolean isCru, String branch) {
        super(url, isCru);
        this.csid = csid;
        this.rep = rep;
        this.branch = branch;
    }

    public Changeset(String rep, String csid, String author, Date date, String msg, List<Revision> revisions, String url, boolean isCru, String branch) {
        this(rep, csid, author, date, msg, revisions, url, isCru, branch, null);
    }

    public Changeset(String rep, String csid, String author, Date date, String msg, List<Revision> revisions, String url, boolean isCru, String branch, List<Review> reviews) {
        super(url, isCru);
        this.csid = csid;
        this.rep = rep;
        this.author = author;
        this.date = date;
        this.revisions = revisions;
        this.msg = msg;
        this.branch = branch;
        this.reviews = reviews;
    }

    public String getRep() {
        return this.rep;
    }

    public void setRep(String rep) {
        this.rep = rep;
    }

    public String getCsid() {
        return this.csid;
    }

    public String getAuthor() {
        return this.author;
    }

    public ApplicationUser getUser() {
        if (this.user == null) {
            this.user = ComponentAccessor.getUserUtil().getUserByName(this.getAuthor());
        }
        return this.user;
    }

    public String getFullName() {
        if (this.getUser() != null) {
            return this.getUser().getDisplayName();
        }
        return null;
    }

    public Date getDate() {
        return this.date;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List<Revision> getRevisions() {
        return this.revisions;
    }

    public void addRevision(Revision rev) {
        this.getOrCreateRevisions().add(rev);
    }

    private synchronized List<Revision> getOrCreateRevisions() {
        if (this.revisions == null) {
            this.revisions = new ArrayList<Revision>();
        }
        return this.revisions;
    }

    public String getOldKey() {
        return this.oldKey;
    }

    public void setOldKey(String oldKey) {
        this.oldKey = oldKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Changeset changeset = (Changeset)o;
        if (this.baseUrl != null ? !this.baseUrl.equals(changeset.baseUrl) : changeset.baseUrl != null) {
            return false;
        }
        if (this.csid != null ? !this.csid.equals(changeset.csid) : changeset.csid != null) {
            return false;
        }
        return !(this.rep != null ? !this.rep.equals(changeset.rep) : changeset.rep != null);
    }

    public int hashCode() {
        int result = this.csid != null ? this.csid.hashCode() : 0;
        result = 31 * result + (this.rep != null ? this.rep.hashCode() : 0);
        result = 31 * result + (this.baseUrl != null ? this.baseUrl.hashCode() : 0);
        return result;
    }

    public void setIncomplete(int incomplete) {
        this.incomplete = incomplete;
    }

    public boolean isIncomplete() {
        return this.incomplete > 0;
    }

    public int getIncompleteCount() {
        return this.incomplete;
    }

    public int getRevisionCount() {
        return this.revisions == null ? 0 : this.revisions.size() + this.incomplete;
    }

    public String getMsgPreview() {
        if (this.msg == null) {
            return "";
        }
        if (this.msg.length() < 200) {
            return this.msg.replaceAll("\r?\n", MSG_PREVIEW_NEWLINE_REPLACEMENT);
        }
        return this.msg.substring(0, 200).replaceAll("\r?\n", MSG_PREVIEW_NEWLINE_REPLACEMENT) + MSG_PREVIEW_ELLIPSIS;
    }

    public boolean isFullyReviewed() {
        for (Revision revision : this.revisions) {
            if (revision.getReviews() == null) {
                throw new IllegalStateException("Cannot check review state of changeset '" + this.csid + "' as reviews have not been retrieved for revision '" + revision.getPath() + "'");
            }
            if (!revision.getReviews().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isReviewsInitialised() {
        return this.reviews != null;
    }

    public List<Review> getReviews() {
        if (this.reviews == null && this.revisions != null) {
            this.reviews = new ArrayList<Review>();
            HashSet<String> permaIds = new HashSet<String>();
            for (Revision revision : this.revisions) {
                if (revision.getReviews() == null) {
                    throw new IllegalStateException("Cannot get all reviews of changeset '" + this.csid + "' as reviews have not been retrieved for revision '" + revision.getPath() + "'");
                }
                List<Review> revisionReviews = revision.getReviews();
                for (Review r : revisionReviews) {
                    if (permaIds.contains(r.getId())) continue;
                    permaIds.add(r.getId());
                    this.reviews.add(r);
                }
            }
        }
        return this.reviews;
    }

    public String toString() {
        return this.rep + ":" + this.csid;
    }

    public String getAssociatedProjectKey() {
        return this.associatedProjectKey;
    }

    public void setAssociatedProjectKey(String associatedProjectKey) {
        this.associatedProjectKey = associatedProjectKey;
    }

    public String toJsonString() {
        return "{\"changeset\":{\"baseUrl\":\"" + this.baseUrl + "\",\"isCru\":" + this.isCru + ",\"csid\":\"" + this.csid + "\"}";
    }

    public String p4JobsFixedAsString() {
        StringBuilder sb = new StringBuilder();
        if (!this.fixesJobs()) {
            return "";
        }
        ArrayList<String> sortedP4Jobs = new ArrayList<String>(this.p4JobsFixed);
        Collections.sort(sortedP4Jobs, KeyComparator.COMPARATOR);
        Iterator iterator = sortedP4Jobs.iterator();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public Set<String> getP4JobsFixed() {
        return this.p4JobsFixed;
    }

    public void setP4JobsFixed(Set<String> p4JobsFixed) {
        this.p4JobsFixed = p4JobsFixed;
    }

    public boolean fixesJobs() {
        return this.p4JobsFixed != null && !this.p4JobsFixed.isEmpty();
    }

    public String getBranch() {
        return this.branch;
    }
}

