/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.fisheye;

import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.SourceErrorReport;
import com.atlassian.jirafisheyeplugin.filter.ChangesetFilter;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ChangeSets {
    private List<Changeset> changesets;
    private List<Changeset> summarisedChangesets;
    private List<SourceErrorReport> repositoryErrors;
    private Map<FishEyeRepository, Integer> summaryIndex;

    public ChangeSets(List<Changeset> changesets, List<Changeset> summarizedChangesets) {
        this.changesets = changesets;
        this.summarisedChangesets = summarizedChangesets;
        this.repositoryErrors = Lists.newArrayList();
    }

    public ChangeSets(List<Changeset> changesets, List<Changeset> summarisedChangesets, List<SourceErrorReport> repositoryErrors) {
        this.changesets = changesets;
        this.summarisedChangesets = summarisedChangesets;
        this.repositoryErrors = Lists.newArrayList(repositoryErrors);
    }

    public void applyFilter(ChangesetFilter filter) {
        filter.filter(this.changesets);
        filter.filter(this.summarisedChangesets);
    }

    public List<Changeset> getChangesets() {
        return this.changesets;
    }

    public List<Changeset> getSummarisedChangesets() {
        return this.summarisedChangesets;
    }

    public List<SourceErrorReport> getErrors() {
        return this.repositoryErrors;
    }

    public boolean hasErrors() {
        return !this.repositoryErrors.isEmpty();
    }

    public void addError(SourceErrorReport error) {
        this.repositoryErrors.add(error);
    }

    public void addErrors(Collection<SourceErrorReport> errors) {
        this.repositoryErrors.addAll(errors);
    }

    public boolean isIncomplete() {
        return this.summarisedChangesets != null && this.summarisedChangesets.size() > 0 || this.summaryIndex != null && this.summaryIndex.size() > 0;
    }

    public void associateWithProject(String projectKey) {
        for (Changeset cs : this.changesets) {
            cs.setAssociatedProjectKey(projectKey);
        }
        for (Changeset cs : this.summarisedChangesets) {
            cs.setAssociatedProjectKey(projectKey);
        }
    }

    public void addSummaryIndex(Map<FishEyeRepository, Integer> summaryIndex) {
        this.summaryIndex = summaryIndex;
    }

    public Map<FishEyeRepository, Integer> getSummaryIndex() {
        return this.summaryIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSets that = (ChangeSets)o;
        if (this.changesets != null ? !this.changesets.equals(that.changesets) : that.changesets != null) {
            return false;
        }
        return !(this.summarisedChangesets != null ? !this.summarisedChangesets.equals(that.summarisedChangesets) : that.summarisedChangesets != null);
    }

    public int hashCode() {
        int result = this.changesets != null ? this.changesets.hashCode() : 0;
        result = 31 * result + (this.summarisedChangesets != null ? this.summarisedChangesets.hashCode() : 0);
        return result;
    }
}

