/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.fisheye;

import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jirafisheyeplugin.cache.FishEyeCache;
import com.atlassian.jirafisheyeplugin.cache.StatisticsStoringCacheImpl;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.Refreshable;
import com.atlassian.jirafisheyeplugin.config.SearchConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.domain.P4Query;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSetManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangeSets;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ChangesetDateComparator;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.OAuthErrorReport;
import com.atlassian.jirafisheyeplugin.domain.fisheye.RepositoryPath;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import com.atlassian.jirafisheyeplugin.domain.fisheye.SourceErrorReport;
import com.atlassian.jirafisheyeplugin.exceptions.ApplinkNotFoundException;
import com.atlassian.jirafisheyeplugin.exceptions.OAuthNotAuthorisedException;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import com.atlassian.jirafisheyeplugin.rest.command.RestCommandFactory;
import com.atlassian.jirafisheyeplugin.rest.eyeql.EyeQLQuery;
import com.atlassian.jirafisheyeplugin.rest.eyeql.WhereClauseFactory;
import com.atlassian.jirafisheyeplugin.rest.response.ChangesetDataFeResponseParser;
import com.atlassian.jirafisheyeplugin.rest.response.ChangesetParser;
import com.atlassian.jirafisheyeplugin.rest.response.CsIdFromChangesetsParser;
import com.atlassian.jirafisheyeplugin.rest.response.P4JobsFixedParser;
import com.atlassian.jirafisheyeplugin.rest.response.SingleRevisionParser;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ChangeSetManagerImpl
implements ChangeSetManager,
Refreshable,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ChangeSetManagerImpl.class);
    private static final int NOT_DEFINED = -1;
    private FishEyeRestApiManager apiManager;
    private AuthenticationContext authenticationContext;
    private FishEyeRepositoryStore repositoryStore;
    private RepositoryPathStore repositoryPathStore;
    private FishEyeConfig fisheyeConfig;
    private RefreshManager refreshManager;
    private FishEyeInstanceStore instanceStore;
    private FishEyeCache cache;

    public ChangeSetManagerImpl(FishEyeRestApiManager apiManager, AuthenticationContext authenticationContext, FishEyeRepositoryStore repositoryStore, RepositoryPathStore repositoryPathStore, FishEyeConfig fisheyeConfig, RefreshManager refreshManager, FishEyeInstanceStore instanceStore) {
        this.apiManager = apiManager;
        this.authenticationContext = authenticationContext;
        this.repositoryStore = repositoryStore;
        this.repositoryPathStore = repositoryPathStore;
        this.fisheyeConfig = fisheyeConfig;
        this.refreshManager = refreshManager;
        this.instanceStore = instanceStore;
    }

    @Override
    public void flushCache() {
        this.initialiseCache();
    }

    protected void initialiseCache() {
        if (this.fisheyeConfig.isValid()) {
            this.cache = new StatisticsStoringCacheImpl(this.fisheyeConfig.getRevisionCacheSize(), this.fisheyeConfig.getRevisionCacheSize() / 8, this.authenticationContext);
        }
    }

    @Override
    public FishEyeCache.CacheStatistics getCacheStatistics() {
        return this.cache.getStatistics();
    }

    @Override
    public ChangeSets getChangesetsForIssue(Issue issue) throws IllegalStateException {
        if (issue == null) {
            throw new IllegalArgumentException("Can not get changesets for null project");
        }
        Project project = issue.getProjectObject();
        String projectKey = project.getKey();
        String issueKey = issue.getKey();
        return this.getChangesetsForIssue(issueKey, projectKey);
    }

    @Override
    public ChangeSets getChangesetsForIssue(final String issueKey, String projectKey) {
        final SearchConfig searchConfig = new SearchConfig(null, this.fisheyeConfig.getMaxIssueChangeSets(), this.fisheyeConfig.getMaxRevisions(), false, false, true, 1);
        P4Query<List<Changeset>> query = new P4Query<List<Changeset>>(){

            @Override
            public List<Changeset> doQuery(FishEyeRepository rep) throws IOException {
                return ChangeSetManagerImpl.this.apiManager.callFisheye(rep, RestCommandFactory.listChangesets(rep, issueKey, searchConfig), new ChangesetDataFeResponseParser(rep));
            }
        };
        Set<FishEyeRepository> repositories = this.repositoryStore.getRepositories(projectKey);
        return this.searchForChangeSets(projectKey, query, searchConfig, repositories, issueKey);
    }

    @Override
    public ChangeSets getChangesetsForProject(Project project) throws IllegalStateException, IOException {
        if (project == null) {
            throw new IllegalArgumentException("Can not get changesets for null project");
        }
        final String projectKey = project.getKey();
        boolean hasRepositoryPath = this.repositoryPathStore.hasRepositoryPath(projectKey);
        RepositoryPath repositoryPath = this.repositoryPathStore.getRepositoryPath(projectKey);
        final SearchConfig searchConfig = new SearchConfig(repositoryPath, this.fisheyeConfig.getMaxProjectChangesets(), this.fisheyeConfig.getMaxRevisions(), true, true, false, 1);
        P4Query<List<Changeset>> query = new P4Query<List<Changeset>>(){

            @Override
            public List<Changeset> doQuery(FishEyeRepository rep) throws IOException {
                return ChangeSetManagerImpl.this.apiManager.callFisheye(rep, RestCommandFactory.listChangesets(rep, projectKey, searchConfig), new ChangesetDataFeResponseParser(rep));
            }
        };
        HashSet repositoriesToSearch = hasRepositoryPath ? Sets.newHashSet((Object[])new FishEyeRepository[]{repositoryPath.getRep()}) : this.repositoryStore.getRepositories(projectKey);
        ChangeSets results = this.searchForChangeSets(projectKey, query, searchConfig, repositoriesToSearch, projectKey);
        results.associateWithProject(projectKey);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Changeset> searchForChangeSets(RepositoryPath path, int maxChangesets) throws IOException {
        List<String> csids = this.apiManager.callFisheye(path.getRep(), RestCommandFactory.changesets(path.getPath(), maxChangesets), CsIdFromChangesetsParser.PARSER);
        Iterator<String> iterator = csids.iterator();
        ArrayList<Changeset> changesets = new ArrayList<Changeset>(csids.size());
        String changesetTimerKey = "ChangeSetManager.searchForChangeSets(RepositoryPath, int) path=" + path + " maxchangesets=" + maxChangesets;
        try {
            UtilTimerStack.push((String)changesetTimerKey);
            while (iterator.hasNext() && changesets.size() < maxChangesets) {
                String csid = iterator.next();
                changesets.add(this.getChangeset(path.getRep(), csid));
            }
        }
        finally {
            UtilTimerStack.pop((String)changesetTimerKey);
        }
        return changesets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeSets searchForChangeSets(String projectKey, P4Query<List<Changeset>> query, SearchConfig searchConfig, Set<FishEyeRepository> allRepositoriesToSearch, String queryString) {
        HashSet<FishEyeRepository> legacyReposToSearch = new HashSet<FishEyeRepository>();
        HashMap instancesToSearch = new HashMap();
        if (searchConfig.getRepositoryPath() != null) {
            legacyReposToSearch.add(searchConfig.getRepositoryPath().getRep());
        } else {
            if (!this.repositoryStore.isMapped(projectKey)) {
                for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
                    if (!instance.isCrossRepoCapable(this.apiManager)) continue;
                    instancesToSearch.put(instance, new HashSet());
                }
            }
            for (FishEyeRepository repository : allRepositoriesToSearch) {
                boolean crossRepoCapable = repository.getInstance().isCrossRepoCapable(this.apiManager);
                if (!crossRepoCapable) {
                    legacyReposToSearch.add(repository);
                    continue;
                }
                HashSet<FishEyeRepository> repositories = (HashSet<FishEyeRepository>)instancesToSearch.get(repository.getInstance());
                if (repositories == null) {
                    repositories = new HashSet<FishEyeRepository>();
                    instancesToSearch.put(repository.getInstance(), repositories);
                }
                repositories.add(repository);
            }
        }
        HashMap repoToChangesets = Maps.newHashMap();
        HashMap repoToSummaryIndex = Maps.newHashMap();
        ArrayList errors = Lists.newArrayList();
        if (log.isDebugEnabled()) {
            StringBuilder dbg = new StringBuilder().append("searching the following reps for project '").append(projectKey).append("' = {");
            Object sep = "";
            for (FishEyeRepository repository : legacyReposToSearch) {
                dbg.append((String)sep);
                dbg.append(repository);
                sep = ",";
            }
            dbg.append("}");
            log.debug(dbg.toString());
        }
        String totalTimer = "ChangeSetManager.searchForChangesets()";
        try {
            UtilTimerStack.push((String)"ChangeSetManager.searchForChangesets()");
            for (Map.Entry entry : instancesToSearch.entrySet()) {
                FishEyeInstance instance = (FishEyeInstance)entry.getKey();
                Set reps = (Set)entry.getValue();
                HashMap<String, FishEyeRepository> repositoryMap = new HashMap<String, FishEyeRepository>();
                for (FishEyeRepository repository : reps) {
                    repositoryMap.put(repository.getName(), repository);
                }
                boolean allReposForInstance = this.repositoryStore.getRepositoriesForInstance(instance.getApplicationId()).size() == repositoryMap.size();
                try {
                    List<Changeset> changesets = this.apiManager.callFisheye(instance, RestCommandFactory.listChangesets(instance, queryString, allReposForInstance ? Collections.emptySet() : reps, searchConfig), new ChangesetDataFeResponseParser(repositoryMap));
                    for (Changeset cs : changesets) {
                        FishEyeRepository fishEyeRepository = (FishEyeRepository)repositoryMap.get(cs.getRep());
                        ArrayList<Changeset> repoChangesets = (ArrayList<Changeset>)repoToChangesets.get(fishEyeRepository);
                        if (repoChangesets == null) {
                            repoChangesets = new ArrayList<Changeset>();
                            repoToChangesets.put(fishEyeRepository, repoChangesets);
                        }
                        repoChangesets.add(cs);
                    }
                }
                catch (ApplinkNotFoundException e) {
                    log.debug(e.getMessage());
                }
                catch (OAuthNotAuthorisedException e) {
                    errors.add(new OAuthErrorReport(instance, (AuthorisationURIGenerator)e, e.getMessage()));
                }
                catch (IOException e) {
                    errors.add(new SourceErrorReport(instance, e.getMessage()));
                }
            }
            for (FishEyeRepository fishEyeRepository : legacyReposToSearch) {
                try {
                    int count;
                    List<Changeset> changesetsFromFisheye;
                    String perRepTimer = "searchForChangesets() P4Query.doQuery() rep=" + fishEyeRepository.getName();
                    try {
                        UtilTimerStack.push((String)perRepTimer);
                        changesetsFromFisheye = P4Query.doQuery(query, fishEyeRepository);
                    }
                    finally {
                        UtilTimerStack.pop((String)perRepTimer);
                    }
                    Iterator<Changeset> changesetIterator = searchConfig.isRevChronological() ? new ReverseListIterator<Changeset>(changesetsFromFisheye) : changesetsFromFisheye.iterator();
                    for (count = 0; changesetIterator.hasNext() && (searchConfig.getMaxChangesets() == -1 || count < searchConfig.getMaxChangesets()); ++count) {
                        Changeset changeSet = changesetIterator.next();
                        if (!repoToChangesets.containsKey(fishEyeRepository)) {
                            repoToChangesets.put(fishEyeRepository, Lists.newArrayList());
                        }
                        ((List)repoToChangesets.get(fishEyeRepository)).add(changeSet);
                    }
                    while (searchConfig.isAddSummary() && changesetIterator.hasNext()) {
                        changesetIterator.next();
                        if (!repoToSummaryIndex.containsKey(fishEyeRepository)) {
                            repoToSummaryIndex.put(fishEyeRepository, count);
                            continue;
                        }
                        repoToSummaryIndex.put(fishEyeRepository, (Integer)repoToSummaryIndex.get(fishEyeRepository) + 1);
                    }
                }
                catch (ApplinkNotFoundException e) {
                    log.debug(e.getMessage());
                }
                catch (OAuthNotAuthorisedException e) {
                    errors.add(new OAuthErrorReport(fishEyeRepository, (AuthorisationURIGenerator)e, e.getMessage()));
                }
                catch (IOException e) {
                    errors.add(new SourceErrorReport(fishEyeRepository, e.getMessage()));
                }
            }
            ChangeSets collated = this.truncateAndSummariseChangesets(searchConfig, repoToChangesets, repoToSummaryIndex);
            collated.addErrors(errors);
            ChangeSets changeSets = collated;
            return changeSets;
        }
        finally {
            UtilTimerStack.pop((String)"ChangeSetManager.searchForChangesets()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Changeset getChangeset(FishEyeRepository rep, String csid) throws IOException {
        String timerKey = "ChangeSetManager.getChangeset()";
        try {
            UtilTimerStack.push((String)"ChangeSetManager.getChangeset()");
            Changeset cs = this.cache.getChangeset(rep, csid);
            if (cs == null) {
                List<ChangesetParser.ChangesetHolder> csList;
                String singleChangesetTimer = "ChangeSetManager.getChangeset() rep=" + rep.getName() + " csid=" + csid;
                try {
                    UtilTimerStack.push((String)singleChangesetTimer);
                    csList = this.apiManager.callFisheye(rep, RestCommandFactory.changeset(csid), new ChangesetParser(csid, rep.getName()));
                }
                finally {
                    UtilTimerStack.pop((String)singleChangesetTimer);
                }
                ChangesetParser.ChangesetHolder csHolder = csList.get(0);
                cs = csHolder.getChangeset();
                List<ChangesetParser.RevisionKey> keys = csHolder.getRevisionKeys();
                Iterator<ChangesetParser.RevisionKey> iterator = keys.iterator();
                while (iterator.hasNext() && cs.getRevisionCount() < this.fisheyeConfig.getMaxRevisions()) {
                    ChangesetParser.RevisionKey key = iterator.next();
                    cs.addRevision(this.getRevision(rep, key.getPath(), key.getRev()));
                }
                if (cs.getRevisionCount() < keys.size()) {
                    cs.setIncomplete(keys.size() - cs.getRevisionCount());
                }
                cs.setP4JobsFixed(this.getP4JobsFixed(rep, csid));
                this.cache.add(rep, cs);
            }
            Changeset changeset = cs;
            return changeset;
        }
        finally {
            UtilTimerStack.pop((String)"ChangeSetManager.getChangeset()");
        }
    }

    @Override
    public List<Changeset> getMoreChangesets(final Issue issue, final Map<FishEyeRepository, Integer> searchIndex) {
        P4Query<List<Changeset>> query = new P4Query<List<Changeset>>(){

            @Override
            public List<Changeset> doQuery(FishEyeRepository rep) throws IOException {
                SearchConfig searchConfig = new SearchConfig(null, ChangeSetManagerImpl.this.fisheyeConfig.getMaxIssueChangeSets(), 0, false, false, true, 1);
                return ChangeSetManagerImpl.this.apiManager.callFisheye(rep, RestCommandFactory.listMoreChangesets(rep, issue.getKey(), searchConfig, searchIndex), new ChangesetDataFeResponseParser(rep));
            }
        };
        String projectKey = issue.getProjectObject().getKey();
        Set<FishEyeRepository> repositories = this.repositoryStore.getRepositories(projectKey);
        ChangeSets foundMoreChangesets = this.searchForChangeSets(projectKey, query, new SearchConfig(null, Integer.MAX_VALUE, 0, false, false, false, 1), repositories, issue.getKey());
        return foundMoreChangesets.getChangesets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getP4JobsFixed(FishEyeRepository rep, final String csid) throws IOException {
        String timerKey = "ChangeSetManager.getP4JobsFixed() rep=" + rep.getName() + " csid=" + csid;
        P4Query<Set<String>> query = new P4Query<Set<String>>(){

            @Override
            public Set<String> doQuery(FishEyeRepository rep) throws IOException {
                EyeQLQuery query = new EyeQLQuery();
                query.setDir("/");
                query.addWhereClause(WhereClauseFactory.csidIs(csid));
                query.addReturnClause("p4:jobsFixed");
                return new HashSet<String>(ChangeSetManagerImpl.this.apiManager.callFisheye(rep, RestCommandFactory.query(query), P4JobsFixedParser.PARSER));
            }
        };
        try {
            UtilTimerStack.push((String)timerKey);
            Set<String> set = P4Query.doQuery(query, rep);
            return set;
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Revision getRevision(FishEyeRepository rep, String path, String rev) throws IOException {
        String timerKey = "ChangeSetManager.getRevision() rep=" + rep.getName() + " path=" + path + "@" + rev;
        try {
            UtilTimerStack.push((String)timerKey);
            Revision revision = this.cache.getRevision(rep, path, rev);
            if (revision == null) {
                List<Revision> revisionList = this.apiManager.callFisheye(rep, RestCommandFactory.revision(path, rev), new SingleRevisionParser(rep));
                revision = revisionList.get(0);
                this.cache.add(rep, revision);
            }
            Revision revision2 = revision;
            return revision2;
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    protected ChangeSets truncateAndSummariseChangesets(SearchConfig searchConfig, Map<FishEyeRepository, List<Changeset>> repoToChangesets, Map<FishEyeRepository, Integer> summaryIndexes) {
        HashMap changesetToRepoIndex = Maps.newHashMap();
        for (Map.Entry<FishEyeRepository, List<Changeset>> entry : repoToChangesets.entrySet()) {
            for (Changeset c : entry.getValue()) {
                changesetToRepoIndex.put(c, entry.getKey());
            }
        }
        ArrayList changesets = Lists.newArrayList();
        for (List<Changeset> list : repoToChangesets.values()) {
            changesets.addAll(list);
        }
        ChangesetDateComparator changesetDateComparator = searchConfig.isRevChronological() ? ChangesetDateComparator.REVERSE_CHRONOLOGICAL : ChangesetDateComparator.CHRONOLOGICAL;
        Collections.sort(changesets, changesetDateComparator);
        int n = searchConfig.getMaxChangesets() > changesets.size() ? changesets.size() : searchConfig.getMaxChangesets();
        ArrayList truncated = Lists.newArrayList(changesets.subList(0, n));
        changesets.removeAll(truncated);
        ArrayList summarized = Lists.newArrayList((Iterable)changesets);
        for (Changeset excessChangeset : summarized) {
            FishEyeRepository excessChangesetRepository = (FishEyeRepository)changesetToRepoIndex.get(excessChangeset);
            if (!summaryIndexes.containsKey(excessChangesetRepository)) {
                summaryIndexes.put(excessChangesetRepository, 1);
                continue;
            }
            summaryIndexes.put(excessChangesetRepository, summaryIndexes.get(excessChangesetRepository) + 1);
        }
        ChangeSets collated = new ChangeSets(truncated, summarized);
        collated.addSummaryIndex(summaryIndexes);
        return collated;
    }

    @Override
    public void refresh() {
        this.initialiseCache();
    }

    @Override
    public int order() {
        return 40;
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshManager.registerRefreshable(this);
    }

    public static class ReverseListIterator<T>
    implements Iterator<T> {
        ListIterator<T> iterator;

        ReverseListIterator(List<T> list) {
            this.iterator = list.listIterator(list.size());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T next() {
            return this.iterator.previous();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

