/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.crucible;

import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jirafisheyeplugin.config.SearchConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.domain.P4Query;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewFilter;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewList;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.OAuthErrorReport;
import com.atlassian.jirafisheyeplugin.domain.fisheye.SourceErrorReport;
import com.atlassian.jirafisheyeplugin.exceptions.ApplinkNotFoundException;
import com.atlassian.jirafisheyeplugin.exceptions.OAuthNotAuthorisedException;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import com.atlassian.jirafisheyeplugin.rest.command.RestCommandFactory;
import com.atlassian.jirafisheyeplugin.rest.eyeql.EyeQLQuery;
import com.atlassian.jirafisheyeplugin.rest.eyeql.WhereClauseFactory;
import com.atlassian.jirafisheyeplugin.rest.response.ChangesetDataFeResponseParser;
import com.atlassian.jirafisheyeplugin.rest.response.CruRestServiceReviewParser;
import com.atlassian.jirafisheyeplugin.rest.response.UniqueReviewParser;
import com.atlassian.jirafisheyeplugin.rest.response.WholeKeyMatchReviewParser;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewManagerImpl
implements ReviewManager {
    private static final Logger log = LoggerFactory.getLogger(ReviewManagerImpl.class);
    public static final int MAX_REVIEWS_PROJECT = 50;
    private final FishEyeRestApiManager apiManager;
    private final FishEyeManager fishEyeManager;
    private final FishEyeRepositoryStore repositoryStore;
    private final FishEyeConfig fisheyeConfig;
    private final FishEyeInstanceStore instanceStore;

    public ReviewManagerImpl(FishEyeRestApiManager apiManager, FishEyeManager fishEyeManager, FishEyeRepositoryStore repositoryStore, FishEyeConfig fisheyeConfig, FishEyeInstanceStore instanceStore) {
        this.apiManager = apiManager;
        this.fishEyeManager = fishEyeManager;
        this.repositoryStore = repositoryStore;
        this.fisheyeConfig = fisheyeConfig;
        this.instanceStore = instanceStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Review> getReviewsForChangeset(String projectKey, String csid, String repositoryName) throws IOException {
        String timerKey = "ReviewManager.getReviewsForChangeset() rep=" + repositoryName + " projectKey=" + projectKey + " csid=" + csid;
        EyeQLQuery query = new EyeQLQuery().addWhereClause(WhereClauseFactory.csidIs(csid)).addReturnClause("reviews");
        try {
            UtilTimerStack.push((String)timerKey);
            List<Review> list = this.searchForReviews(projectKey, query, repositoryName);
            return list;
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReviewList getReviewsForIssue(String issueKey, String projectKey) {
        String getReviewsForIssueTimerKey = "ReviewManager.getReviewsForIssue() projectKey=" + projectKey + " issuekey=" + issueKey;
        List<Object> reviews = Lists.newArrayList();
        ArrayList errors = Lists.newArrayList();
        try {
            UtilTimerStack.push((String)getReviewsForIssueTimerKey);
            if (this.fisheyeConfig.isTextCruSearch() || this.fishEyeManager.existsCrucibleStandaloneInstances()) {
                reviews.addAll(this.getReviewsFromCrucibleInstances(projectKey, issueKey, true, errors));
            }
            if (this.fisheyeConfig.isChangesetCruSearch()) {
                Pair<Set<FishEyeRepository>, Map<FishEyeInstance, Set<FishEyeRepository>>> repositoriesToSearch = this.splitOutLegacyRepositories(projectKey, this.fishEyeManager.getRepositoriesForProject(projectKey));
                Set legacyReposToSearch = (Set)repositoriesToSearch.first();
                Map instancesToSearch = (Map)repositoriesToSearch.second();
                reviews.addAll(this.getReviewsFromFishEyeInstances(instancesToSearch, issueKey, errors));
                reviews.addAll(this.getReviewsFromRepositories(legacyReposToSearch, issueKey, null, errors));
            }
            reviews = ReviewFilter.unique((List<Review>)reviews);
        }
        finally {
            UtilTimerStack.pop((String)getReviewsForIssueTimerKey);
        }
        return new ReviewList((List<Review>)reviews, errors);
    }

    @Override
    public ReviewList getReviewsForIssue(Issue issue) {
        String issueKey = issue.getKey();
        String projectKey = issue.getProjectObject().getKey();
        return this.getReviewsForIssue(issueKey, projectKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReviewList getReviewsForProject(Project project, int lastNDays) {
        String timerKey = "ReviewManager.getReviewsForProject() project=" + project.getKey() + " lastNDays=" + lastNDays;
        List<Object> reviews = Lists.newArrayList();
        ArrayList errors = Lists.newArrayList();
        try {
            UtilTimerStack.push((String)timerKey);
            if (this.fisheyeConfig.isTextCruSearch() || this.fishEyeManager.existsCrucibleStandaloneInstances()) {
                reviews.addAll(this.getReviewsFromCrucibleInstances(project.getKey(), project.getKey() + "-", false, errors));
            }
            if (this.fisheyeConfig.isChangesetCruSearch()) {
                Pair<Set<FishEyeRepository>, Map<FishEyeInstance, Set<FishEyeRepository>>> repositoriesToSearch = this.splitOutLegacyRepositories(project.getKey(), this.fishEyeManager.getRepositoriesForProject(project.getKey()));
                Set legacyReposToSearch = (Set)repositoriesToSearch.first();
                Map instancesToSearch = (Map)repositoriesToSearch.second();
                reviews.addAll(this.getReviewsFromFishEyeInstances(instancesToSearch, project.getKey(), errors));
                reviews.addAll(this.getReviewsFromRepositories(legacyReposToSearch, project.getKey(), lastNDays, errors));
            }
            reviews = ReviewFilter.unique((List<Review>)reviews);
            reviews = ReviewFilter.orderByKeyAndTruncate((List<Review>)reviews, 50);
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
        return new ReviewList((List<Review>)reviews, errors);
    }

    private Pair<Set<FishEyeRepository>, Map<FishEyeInstance, Set<FishEyeRepository>>> splitOutLegacyRepositories(String projectKey, Collection<FishEyeRepository> allRepositories) {
        HashSet<FishEyeRepository> legacyReposToSearch = new HashSet<FishEyeRepository>();
        HashMap instancesToSearch = new HashMap();
        if (!this.repositoryStore.isMapped(projectKey)) {
            for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
                if (!instance.isCrossRepoCapable(this.apiManager)) continue;
                instancesToSearch.put(instance, new HashSet());
            }
        }
        for (FishEyeRepository repository : allRepositories) {
            boolean crossRepoCapable = repository.getInstance().isCrossRepoCapable(this.apiManager);
            if (!crossRepoCapable) {
                legacyReposToSearch.add(repository);
                continue;
            }
            HashSet<FishEyeRepository> repositories = (HashSet<FishEyeRepository>)instancesToSearch.get(repository.getInstance());
            if (repositories == null) {
                repositories = new HashSet<FishEyeRepository>();
                instancesToSearch.put(repository.getInstance(), repositories);
            }
            repositories.add(repository);
        }
        return Pair.of(legacyReposToSearch, instancesToSearch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Review> getReviewsFromRepositories(Set<FishEyeRepository> repositories, final String term, final Integer lastNDays, List<SourceErrorReport> errors) {
        ArrayList<Review> reviews = new ArrayList<Review>();
        P4Query<List<Review>> q = new P4Query<List<Review>>(){

            @Override
            public List<Review> doQuery(FishEyeRepository rep) throws IOException {
                EyeQLQuery query = new EyeQLQuery();
                query.addWhereClause(WhereClauseFactory.issueKeyOrJobIdMatches(term));
                if (lastNDays != null) {
                    query.addWhereClause(WhereClauseFactory.withinLastNDays(lastNDays));
                }
                query.addReturnClause("reviews");
                return ReviewManagerImpl.this.searchForReviews(query, rep);
            }
        };
        for (FishEyeRepository rep : repositories) {
            if (!rep.getInstance().isCru()) continue;
            String changesetCruSearchTimerKey = "ReviewManager.getReviewsForIssue() changesetCruSearch rep=" + rep.getName();
            try {
                UtilTimerStack.push((String)changesetCruSearchTimerKey);
                List<Review> results = P4Query.doQuery(q, rep);
                reviews.addAll(results);
            }
            catch (ApplinkNotFoundException e) {
                log.debug(e.getMessage());
            }
            catch (OAuthNotAuthorisedException e) {
                errors.add(new OAuthErrorReport(rep.getInstance(), (AuthorisationURIGenerator)e, e.getMessage()));
            }
            catch (IOException e) {
                log.error("(CRU Changeset Search) Error encountered retrieving issue reviews from '" + rep.getName() + "' on '" + rep.getInstance().getUrl() + "'", (Throwable)e);
                errors.add(new SourceErrorReport(rep, e.getMessage()));
            }
            finally {
                UtilTimerStack.pop((String)changesetCruSearchTimerKey);
            }
        }
        return reviews;
    }

    private List<Review> getReviewsFromFishEyeInstances(Map<FishEyeInstance, Set<FishEyeRepository>> instancesToSearch, String query, List<SourceErrorReport> errors) {
        ArrayList<Review> reviews = new ArrayList<Review>();
        SearchConfig searchConfig = new SearchConfig(null, this.fisheyeConfig.getMaxProjectChangesets(), 0, false, false, true, 1);
        for (Map.Entry<FishEyeInstance, Set<FishEyeRepository>> entry : instancesToSearch.entrySet()) {
            FishEyeInstance instance = entry.getKey();
            if (!instance.isCru()) continue;
            Set<FishEyeRepository> reps = entry.getValue();
            HashMap<String, FishEyeRepository> repositoryMap = new HashMap<String, FishEyeRepository>();
            for (FishEyeRepository repository : reps) {
                repositoryMap.put(repository.getName(), repository);
            }
            boolean allReposForInstance = this.repositoryStore.getRepositoriesForInstance(instance.getApplicationId()).size() == repositoryMap.size();
            try {
                List<Changeset> changesets = this.apiManager.callFisheye(instance, RestCommandFactory.listChangesets(instance, query, allReposForInstance ? Collections.emptySet() : reps, searchConfig), new ChangesetDataFeResponseParser(repositoryMap));
                for (Changeset cs : changesets) {
                    reviews.addAll(cs.getReviews());
                }
            }
            catch (ApplinkNotFoundException e) {
                log.debug(e.getMessage());
            }
            catch (OAuthNotAuthorisedException e) {
                errors.add(new OAuthErrorReport(instance, (AuthorisationURIGenerator)e, e.getMessage()));
            }
            catch (IOException e) {
                errors.add(new SourceErrorReport(instance, e.getMessage()));
            }
        }
        return reviews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Review> getReviewsFromCrucibleInstances(String projectKey, String searchTerm, boolean filterRx, List<SourceErrorReport> errors) {
        ArrayList<Review> reviews = new ArrayList<Review>();
        Collection<FishEyeInstance> projectInstances = this.fishEyeManager.getInstancesForProject(projectKey);
        if (projectInstances.isEmpty()) {
            for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
                if (!instance.isCrossRepoCapable(this.apiManager)) continue;
                projectInstances.add(instance);
            }
        }
        for (FishEyeInstance instance : projectInstances) {
            if (!instance.isCru()) continue;
            String textSearchTimerKey = "ReviewManager.getReviewsFromCrucibleInstances() textSearch searchTerm=" + searchTerm + " instance=" + instance.getApplicationId();
            try {
                UtilTimerStack.push((String)textSearchTimerKey);
                reviews.addAll(this.searchForReviews(searchTerm, instance, filterRx));
            }
            catch (ApplinkNotFoundException e) {
                log.debug(e.getMessage());
            }
            catch (OAuthNotAuthorisedException e) {
                errors.add(new OAuthErrorReport(instance, (AuthorisationURIGenerator)e, e.getMessage()));
            }
            catch (IOException e) {
                log.error("(CRU Text Search) Error encountered retrieving issue reviews from '" + instance.getUrl() + "' for '" + searchTerm + "'", (Throwable)e);
                errors.add(new SourceErrorReport(instance, e.getMessage()));
            }
            finally {
                UtilTimerStack.pop((String)textSearchTimerKey);
            }
        }
        return reviews;
    }

    private List<Review> searchForReviews(String text, FishEyeInstance instance, boolean filterRx) throws IOException {
        if (instance.isCru()) {
            return this.apiManager.callFisheye(instance, RestCommandFactory.reviewSearch(text), filterRx ? new WholeKeyMatchReviewParser(text) : CruRestServiceReviewParser.PARSER);
        }
        return Collections.emptyList();
    }

    private List<Review> searchForReviews(String projectKey, final EyeQLQuery query, String repositoryName) throws IOException {
        List<FishEyeRepository> repositoriesForJiraProjectKey = this.repositoryStore.getRepositoriesForJiraProjectKey(repositoryName, projectKey);
        if (repositoriesForJiraProjectKey.isEmpty()) {
            throw new IllegalStateException(String.format("The specified repository '%s' is not currently configured for jira project '%s'", repositoryName, projectKey));
        }
        final ArrayList errors = Lists.newArrayList();
        ArrayList foundReviews = Lists.newArrayList();
        Iterable aggregatedReviews = Iterables.transform(repositoriesForJiraProjectKey, (Function)new Function<FishEyeRepository, List<Review>>(){

            public List<Review> apply(FishEyeRepository repo) {
                try {
                    return ReviewManagerImpl.this.searchForReviews(query, repo);
                }
                catch (IOException e) {
                    errors.add(Pair.of((Object)repo, (Object)e));
                    return Collections.emptyList();
                }
            }
        });
        for (List r : aggregatedReviews) {
            foundReviews.addAll(r);
        }
        if (!errors.isEmpty()) {
            String queryString = query.toString();
            for (Pair error : errors) {
                log.warn(String.format("Error searching for reviews: query=[%s] repository=[%s] instance=[%s]", queryString, ((FishEyeRepository)error.first()).getName(), ((FishEyeRepository)error.first()).getInstance()), (Throwable)error.second());
            }
            throw (IOException)((Pair)errors.get(0)).second();
        }
        return foundReviews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Review> searchForReviews(EyeQLQuery query, FishEyeRepository rep) throws IOException {
        List<Review> reviews;
        String timerKey = "ReviewManagerImpl.searchForReviews() rep=" + rep.getName();
        try {
            UtilTimerStack.push((String)timerKey);
            reviews = this.apiManager.callFisheye(rep, RestCommandFactory.query(query), UniqueReviewParser.PARSER);
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
        return reviews;
    }

    protected boolean reviewsAreValid(List<Review> reviews) {
        for (Review review : reviews) {
            if (review.isValid()) continue;
            return false;
        }
        return true;
    }
}

