/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.crucible;

import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewIdComparator
implements Comparator<Review> {
    public static ReviewIdComparator COMPARATOR = new ReviewIdComparator();
    public static ReviewIdComparator REVERSE_COMPARATOR = new ReviewIdComparator(){

        @Override
        public int compare(Review o1, Review o2) {
            return -super.compare(o1, o2);
        }
    };
    private static Logger log = LoggerFactory.getLogger(ReviewIdComparator.class);

    @Override
    public int compare(Review o1, Review o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int id1 = this.parseIdNumber(o1);
        int id2 = this.parseIdNumber(o2);
        return id1 - id2;
    }

    private int parseIdNumber(Review r) {
        try {
            String id = r.getId();
            return Integer.parseInt(id.substring(id.lastIndexOf(45) + 1));
        }
        catch (NumberFormatException e) {
            log.warn("Error parsing id from review: " + r);
            return -1;
        }
    }
}

