/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.domain.crucible;

import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.util.FishEyeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ReviewFilter {
    private static final Comparator<Review> ISSUE_KEY_REVIEW_COMPARATOR = new Comparator<Review>(){

        @Override
        public int compare(Review o1, Review o2) {
            String r1 = ReviewFilter.mostRecentKey(o1);
            String r2 = ReviewFilter.mostRecentKey(o2);
            if (r1 == null) {
                return -1;
            }
            if (r2 == null) {
                return 1;
            }
            return FishEyeUtil.numericPart(r1) - FishEyeUtil.numericPart(r2);
        }
    };
    private static final Comparator<Review> ISSUE_KEY_REVIEW_COMPARATOR_REVERSE = new Comparator<Review>(){

        @Override
        public int compare(Review o1, Review o2) {
            return -ISSUE_KEY_REVIEW_COMPARATOR.compare(o1, o2);
        }
    };

    public static List<Review> unique(List<Review> reviews) {
        reviews = new ArrayList<Review>(reviews);
        HashSet<String> keys = new HashSet<String>();
        Iterator<Review> iterator = reviews.iterator();
        while (iterator.hasNext()) {
            Review review = iterator.next();
            String reviewKey = ReviewFilter.makeKey(review);
            if (keys.contains(reviewKey)) {
                iterator.remove();
                continue;
            }
            keys.add(reviewKey);
        }
        return reviews;
    }

    private static String makeKey(Review review) {
        return review.getBaseUrl() + ":" + review.getId();
    }

    public static List<Review> orderByKeyAndTruncate(List<Review> reviews, int count) {
        reviews = new ArrayList<Review>(reviews);
        Collections.sort(reviews, ISSUE_KEY_REVIEW_COMPARATOR_REVERSE);
        if (reviews.size() > count) {
            return new ArrayList<Review>(reviews.subList(0, count));
        }
        return reviews;
    }

    private static String mostRecentKey(Review review) {
        return FishEyeUtil.mostRecentIssueKey(review.getTitle() + " " + review.getDescription());
    }
}

