/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.ual;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeApplicationTypeCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(FishEyeApplicationTypeCondition.class);
    private static final Class<FishEyeCrucibleApplicationType> FECRU_TYPE = FishEyeCrucibleApplicationType.class;
    private final TypeAccessor typeAccessor;

    public FishEyeApplicationTypeCondition(TypeAccessor typeAccessor) {
        this.typeAccessor = typeAccessor;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ApplicationLink applicationLink = (ApplicationLink)context.get("applicationLink");
        boolean shouldDisplay = true;
        if (applicationLink == null) {
            log.warn("This page has no applicationLink context. Ignoring " + this.getClass().getSimpleName());
        } else {
            ApplicationType type = this.typeAccessor.getApplicationType(FECRU_TYPE);
            if (type == null) {
                log.warn("type '{}' specified in {} is not installed, condition evaluates to false.", (Object)FECRU_TYPE.getName(), (Object)this.getClass().getSimpleName());
                shouldDisplay = false;
            } else {
                shouldDisplay = type.getClass().isAssignableFrom(applicationLink.getType().getClass());
            }
        }
        return shouldDisplay;
    }
}

