/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.ual;

import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleProjectEntityType;
import com.atlassian.applinks.api.application.fecru.FishEyeRepositoryEntityType;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.applinks.api.event.EntityLinkAddedEvent;
import com.atlassian.applinks.api.event.EntityLinkDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectManager;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.upgrade.ual.event.UpgradeFinishedEvent;
import com.atlassian.jirafisheyeplugin.upgrade.ual.event.UpgradeStartedEvent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class EntityLinkEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(EntityLinkEventListener.class);
    private final EventPublisher eventPublisher;
    private final AtomicBoolean isUpgradeInProgress = new AtomicBoolean(false);
    private final com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceManager fishEyeInstanceManager;
    private final FishEyeRepositoryManager fishEyeRepositoryManager;
    private final CrucibleProjectManager crucibleProjectManager;
    private final ProjectManager projectManager;
    private final FishEyeRepositoryStore legacyRepositoryStore;
    private final FishEyeInstanceManager legacyInstanceManager;
    private final CrucibleProjectStore legacyProjectStore;

    public EntityLinkEventListener(EventPublisher eventPublisher, com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceManager fishEyeInstanceManager, FishEyeRepositoryManager fishEyeRepositoryManager, CrucibleProjectManager crucibleProjectManager, ProjectManager projectManager, FishEyeRepositoryStore legacyRepositoryStore, FishEyeInstanceManager legacyInstanceManager, CrucibleProjectStore legacyProjectStore) {
        this.eventPublisher = eventPublisher;
        this.fishEyeInstanceManager = fishEyeInstanceManager;
        this.fishEyeRepositoryManager = fishEyeRepositoryManager;
        this.crucibleProjectManager = crucibleProjectManager;
        this.projectManager = projectManager;
        this.legacyRepositoryStore = legacyRepositoryStore;
        this.legacyInstanceManager = legacyInstanceManager;
        this.legacyProjectStore = legacyProjectStore;
    }

    @EventListener
    public void onCreate(EntityLinkAddedEvent entityLinkEvent) {
        if (this.isUpgradeInProgress.get()) {
            return;
        }
        if (entityLinkEvent.getApplicationType() instanceof FishEyeCrucibleApplicationType) {
            Class localEntityTypeClass;
            if (log.isDebugEnabled()) {
                log.debug("A link to a FishEye repository or Crucible project was created: {}", (Object)ToStringBuilder.reflectionToString(entityLinkEvent));
            }
            if (!JiraProjectEntityType.class.isAssignableFrom(localEntityTypeClass = entityLinkEvent.getLocalType())) {
                log.debug("Local entity type '{}' is not a JIRA Project, skipping", (Object)localEntityTypeClass.getName());
                return;
            }
            String jiraProjectKey = entityLinkEvent.getLocalKey();
            Project jiraProject = this.projectManager.getProjectObjByKey(jiraProjectKey);
            if (jiraProject == null) {
                log.error("Project '{}' referenced in EntityLink '{}' does not exist", (Object)jiraProjectKey, (Object)ToStringBuilder.reflectionToString(entityLinkEvent));
                return;
            }
            FishEyeInstance fishEyeInstance = this.fishEyeInstanceManager.load(entityLinkEvent.getApplicationId());
            if (fishEyeInstance == null) {
                log.debug("Application '{}' is unmapped, skipping", (Object)entityLinkEvent.getApplicationId());
                return;
            }
            this.fishEyeInstanceManager.fetchRepositoryAndProjectLists(fishEyeInstance);
            EntityType remoteEntityType = entityLinkEvent.getEntityType();
            if (remoteEntityType instanceof FishEyeRepositoryEntityType) {
                String repositoryName = entityLinkEvent.getEntityKey();
                FishEyeRepository repository = this.fishEyeRepositoryManager.load(fishEyeInstance, repositoryName);
                if (repository == null) {
                    log.debug("FishEyeRepository '{}' not found for instance '{}'", (Object)entityLinkEvent.getEntityKey(), (Object)fishEyeInstance.getName());
                    return;
                }
                repository.map(jiraProject);
                this.fishEyeRepositoryManager.update(repository);
                log.debug("Mapped JIRA project '{}' to FishEye repository '{}'", (Object)jiraProjectKey, (Object)repository.getName());
            } else if (remoteEntityType instanceof FishEyeCrucibleProjectEntityType) {
                String crucibleProjectKey;
                List<String> knownCrucibleProjectKeys = this.crucibleProjectManager.getKeysForInstance(fishEyeInstance);
                if (!knownCrucibleProjectKeys.contains(crucibleProjectKey = entityLinkEvent.getEntityKey())) {
                    log.debug("The Crucible project '{}' doesn't exist for instance {}, skipping", (Object)entityLinkEvent.getEntityKey(), (Object)fishEyeInstance.getName());
                    return;
                }
                this.crucibleProjectManager.addMapping(fishEyeInstance, jiraProject, crucibleProjectKey);
                log.debug("Associated Crucible project '{}' to JIRA project '{}'", (Object)crucibleProjectKey, (Object)jiraProject);
            }
        }
    }

    @EventListener
    public void onDelete(EntityLinkDeletedEvent entityLinkEvent) {
        if (this.isUpgradeInProgress.get()) {
            return;
        }
        if (entityLinkEvent.getApplicationType() instanceof FishEyeCrucibleApplicationType) {
            String jiraProjectKey;
            Project jiraProject;
            if (log.isDebugEnabled()) {
                log.debug("A link to a FishEye repository or Crucible project was created: {}", (Object)ToStringBuilder.reflectionToString(entityLinkEvent));
            }
            if ((jiraProject = this.projectManager.getProjectObjByKey(jiraProjectKey = entityLinkEvent.getLocalKey())) == null) {
                log.error("Project '{}' referenced in EntityLink '{}' does not exist", (Object)jiraProjectKey, (Object)ToStringBuilder.reflectionToString(entityLinkEvent));
                return;
            }
            FishEyeInstance fishEyeInstance = this.fishEyeInstanceManager.load(entityLinkEvent.getApplicationId());
            if (fishEyeInstance == null) {
                log.debug("Application '{}' is unmapped, skipping", (Object)entityLinkEvent.getApplicationId());
                return;
            }
            EntityType entityType = entityLinkEvent.getEntityType();
            if (entityType instanceof FishEyeRepositoryEntityType) {
                com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance legacyInstance;
                FishEyeRepository repo = this.fishEyeRepositoryManager.load(fishEyeInstance, entityLinkEvent.getEntityKey());
                if (repo == null) {
                    log.debug("Deleted FishEye repository '{}' was unmapped, skipping", (Object)entityLinkEvent.getEntityKey());
                    return;
                }
                repo.unMap(jiraProject);
                if (this.legacyRepositoryStore != null && (legacyInstance = this.legacyInstanceManager.load(entityLinkEvent.getApplicationId())) != null) {
                    this.legacyRepositoryStore.removeProjectFromRepository(jiraProjectKey, repo.getName(), legacyInstance.getId());
                }
                this.fishEyeRepositoryManager.update(repo);
                log.debug("Deleted FishEyeRepository '{}'", (Object)repo.getName());
            } else if (entityType instanceof FishEyeCrucibleProjectEntityType) {
                com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance legacyInstance;
                String crucibleProjectKey = entityLinkEvent.getEntityKey();
                if (!this.crucibleProjectManager.getKeysForInstance(fishEyeInstance).contains(crucibleProjectKey)) {
                    log.debug("Deleted Crucible project '{}' was unmapped, skipping", (Object)crucibleProjectKey);
                    return;
                }
                this.crucibleProjectManager.removeMapping(fishEyeInstance, jiraProject, crucibleProjectKey);
                if (this.legacyRepositoryStore != null && (legacyInstance = this.legacyInstanceManager.load(entityLinkEvent.getApplicationId())) != null) {
                    Collection mappedCrucibleProjectKeys = this.legacyProjectStore.getMappedCrucibleProjectKeys(crucibleProjectKey, legacyInstance.getId());
                    this.legacyProjectStore.setDefaultCrucibleProject(mappedCrucibleProjectKeys, crucibleProjectKey, legacyInstance.getId());
                }
                log.debug("Removed mapping for Crucible '{}' and JIRA project '{}'", (Object)crucibleProjectKey, (Object)jiraProjectKey);
            }
        }
    }

    @EventListener
    public void onUpgradeStarted(UpgradeStartedEvent upgradeStarted) {
        this.isUpgradeInProgress.set(true);
    }

    @EventListener
    public void onUpgradeFinished(UpgradeFinishedEvent upgradeFinished) {
        this.isUpgradeInProgress.set(false);
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

