/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.ual;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkAuthConfigChangedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstanceBuilder;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ServerInfo;
import com.atlassian.jirafisheyeplugin.upgrade.ual.event.UpgradeFinishedEvent;
import com.atlassian.jirafisheyeplugin.upgrade.ual.event.UpgradeStartedEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ApplicationLinkEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLinkEventListener.class);
    private final EventPublisher eventPublisher;
    private final FishEyeInstanceManager fishEyeInstanceManager;
    private final AtomicBoolean isUpgradeInProgress = new AtomicBoolean(false);

    public ApplicationLinkEventListener(EventPublisher eventPublisher, FishEyeInstanceManager fishEyeInstanceManager) {
        this.eventPublisher = eventPublisher;
        this.fishEyeInstanceManager = fishEyeInstanceManager;
    }

    @EventListener
    public void onCreate(ApplicationLinkAddedEvent applicationLinkEvent) {
        if (this.isUpgradeInProgress.get()) {
            return;
        }
        if (applicationLinkEvent.getApplicationType() instanceof FishEyeCrucibleApplicationType) {
            if (log.isDebugEnabled()) {
                log.debug("A FishEye/Crucible application link was created: {}", (Object)ToStringBuilder.reflectionToString(applicationLinkEvent));
            }
            this.fishEyeInstanceManager.create(applicationLinkEvent.getApplicationLink());
        }
    }

    @EventListener
    public void onDelete(ApplicationLinkDeletedEvent applicationLinkEvent) {
        if (this.isUpgradeInProgress.get()) {
            return;
        }
        if (applicationLinkEvent.getApplicationType() instanceof FishEyeCrucibleApplicationType) {
            FishEyeInstance feInstance;
            if (log.isDebugEnabled()) {
                log.debug("A FishEye/Crucible application link was deleted: {}", (Object)ToStringBuilder.reflectionToString(applicationLinkEvent));
            }
            if ((feInstance = this.fishEyeInstanceManager.load(applicationLinkEvent.getApplicationId())) != null) {
                log.debug("Deleting FishEye instance '{}'", (Object)feInstance.getName());
                this.fishEyeInstanceManager.delete(feInstance);
            }
        }
    }

    @EventListener
    public void onUpdateId(ApplicationLinksIDChangedEvent applicationLinkEvent) {
        if (this.isUpgradeInProgress.get()) {
            return;
        }
        if (applicationLinkEvent.getApplicationType() instanceof FishEyeCrucibleApplicationType) {
            FishEyeInstance instance;
            if (log.isDebugEnabled()) {
                log.debug("A FishEye/Crucible application has changed its id: {}", (Object)ToStringBuilder.reflectionToString(applicationLinkEvent));
            }
            if ((instance = this.fishEyeInstanceManager.load(applicationLinkEvent.getOldApplicationId())) != null) {
                this.fishEyeInstanceManager.update(FishEyeInstanceBuilder.copyOf(instance).withApplicationId(applicationLinkEvent.getApplicationId()).build());
                log.debug("Changed ApplicationId on FishEye instance '{}'", (Object)instance.getName());
            }
        }
    }

    @EventListener
    public void onAuthConfigChanged(ApplicationLinkAuthConfigChangedEvent authConfigChangedEvent) {
        FishEyeInstance fishEyeInstance;
        if (this.isUpgradeInProgress.get()) {
            return;
        }
        if (authConfigChangedEvent.getApplicationType() instanceof FishEyeCrucibleApplicationType && (fishEyeInstance = this.fishEyeInstanceManager.load(authConfigChangedEvent.getApplicationId())) != null) {
            ServerInfo serverInfo = this.fishEyeInstanceManager.fetchServerInfo(authConfigChangedEvent.getApplicationLink());
            this.fishEyeInstanceManager.fetchRepositoryAndProjectLists(fishEyeInstance);
            this.fishEyeInstanceManager.update(FishEyeInstanceBuilder.copyOf(fishEyeInstance).withHasBeenInitialised(true).withIsCrucible(serverInfo.isCrucible()).withIsCrucibleStandalone(serverInfo.isCrucibleStandalone()).build());
        }
    }

    @EventListener
    public void onDetailsChanged(ApplicationLinkDetailsChangedEvent detailsChangedEvent) {
        if (this.isUpgradeInProgress.get()) {
            return;
        }
        if (detailsChangedEvent.getApplicationType() instanceof FishEyeCrucibleApplicationType) {
            FishEyeInstance fishEyeInstance;
            if (log.isDebugEnabled()) {
                log.debug("A FishEye/Crucible instance has been updated: {}", (Object)ToStringBuilder.reflectionToString(detailsChangedEvent));
            }
            if ((fishEyeInstance = this.fishEyeInstanceManager.load(detailsChangedEvent.getApplicationId())) != null) {
                ApplicationLink applicationLink = detailsChangedEvent.getApplicationLink();
                this.fishEyeInstanceManager.update(FishEyeInstanceBuilder.copyOf(fishEyeInstance).withName(String.valueOf(applicationLink.getName())).withUrl(String.valueOf(applicationLink.getDisplayUrl())).build());
            }
        }
    }

    @EventListener
    public void onUpgradeStarted(UpgradeStartedEvent upgradeStarted) {
        this.isUpgradeInProgress.set(true);
    }

    @EventListener
    public void onUpgradeFinished(UpgradeFinishedEvent upgradeFinished) {
        this.isUpgradeInProgress.set(false);
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

