/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.properties;

import com.atlassian.jirafisheyeplugin.config.properties.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class CollectionPropertyHelper {
    private static final String PROPERTY_VALUE_DELIMITER_LIST = ", ";
    private static final String PROPERTY_VALUE_DELIMITER = ", ";

    public static <T> Collection<T> toCollection(String value, Converter<T> converter) {
        ArrayList<T> values = new ArrayList<T>();
        StringTokenizer tokenizer = new StringTokenizer(value, ", ");
        while (tokenizer.hasMoreTokens()) {
            T newValue = converter.toValue(tokenizer.nextToken());
            if (newValue == null) continue;
            values.add(newValue);
        }
        return values;
    }

    public static <T> String fromCollection(Collection<T> values, Converter<T> converter) {
        StringBuilder buff = new StringBuilder();
        String sep = "";
        for (T value : values) {
            buff.append(sep);
            sep = ", ";
            buff.append(converter.fromValue(value));
        }
        return buff.toString();
    }
}

