/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.properties;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jirafisheyeplugin.config.properties.ApplicationLinkProjectProperty;
import com.atlassian.jirafisheyeplugin.config.properties.CollectionPropertyHelper;
import com.atlassian.jirafisheyeplugin.config.properties.Converter;
import com.atlassian.jirafisheyeplugin.config.properties.ProjectKey;
import com.atlassian.jirafisheyeplugin.config.properties.converters.StringIdentityConverter;
import java.util.ArrayList;
import java.util.Collection;

public class CollectionProjectProperty<K extends ProjectKey, T>
extends ApplicationLinkProjectProperty<Collection<T>, K> {
    public static final Converter<String> IDENTITY_CONVERTER = new StringIdentityConverter();
    private final Converter<T> converter;

    public CollectionProjectProperty(String keyPrefix, String keySuffix, Converter<T> converter) {
        super(keyPrefix, keySuffix);
        this.converter = converter;
    }

    @Override
    public Collection<T> get(ApplicationLink link, K projectKey) {
        String value = this.getValue(link, projectKey);
        if (value != null) {
            return CollectionPropertyHelper.toCollection(value, this.converter);
        }
        return new ArrayList(0);
    }

    @Override
    public void set(ApplicationLink link, K projectKey, Collection<T> values) {
        this.setValue(link, projectKey, values.isEmpty() ? null : CollectionPropertyHelper.fromCollection(values, this.converter));
    }
}

