/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.properties;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jirafisheyeplugin.config.properties.ApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.config.properties.CollectionPropertyHelper;
import com.atlassian.jirafisheyeplugin.config.properties.Converter;
import java.util.Collection;
import java.util.Collections;

public class CollectionApplicationLinkProperty<E>
extends ApplicationLinkProperty<Collection<E>> {
    private final Converter<E> converter;

    public CollectionApplicationLinkProperty(String key, Converter<E> converter) {
        super(key);
        this.converter = converter;
    }

    @Override
    public Collection<E> get(ApplicationLink link) {
        String value = this.getValue(link);
        if (value != null) {
            return CollectionPropertyHelper.toCollection(value, this.converter);
        }
        return Collections.emptyList();
    }

    @Override
    public void set(ApplicationLink link, Collection<E> value) {
        if (value.isEmpty()) {
            this.remove(link);
        } else {
            this.setValue(link, CollectionPropertyHelper.fromCollection(value, this.converter));
        }
    }
}

