/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.fisheye;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.Refreshable;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.config.properties.CollectionApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.config.properties.ProjectKey;
import com.atlassian.jirafisheyeplugin.config.properties.StringProjectProperty;
import com.atlassian.jirafisheyeplugin.config.properties.converters.StringIdentityConverter;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.RepositoryPath;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class RepositoryPathStoreImpl
implements RepositoryPathStore,
FishEyePropertyKeys,
Refreshable,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(RepositoryPathStoreImpl.class);
    private static final CollectionApplicationLinkProperty<String> JIRA_PROJECT_WITH_PATH_PROPERTY = new CollectionApplicationLinkProperty<String>("fisheye.projects.with.repository.paths", new StringIdentityConverter());
    private static final StringProjectProperty<ProjectKey.JIRA> FISHEYE_REPOSITORY_WITH_PATH_PROPERTY = new StringProjectProperty("fisheye.", ".repository");
    private static final StringProjectProperty<ProjectKey.JIRA> PATH_PROPERTY = new StringProjectProperty("fisheye.", ".repository.path");
    private final ApplicationLinkService applicationLinkService;
    private final FishEyeRepositoryStore repositoryStore;
    private final ProjectManager projectManager;
    private final RefreshManager refreshManager;
    protected final Map<Long, RepositoryPath> jiraProjectIdToRepositoryPathMap = new MapMaker().concurrencyLevel(10).makeMap();

    public RepositoryPathStoreImpl(ApplicationLinkService applicationLinkService, FishEyeRepositoryStore repositoryStore, ProjectManager projectManager, RefreshManager refreshManager) {
        this.applicationLinkService = applicationLinkService;
        this.repositoryStore = repositoryStore;
        this.projectManager = projectManager;
        this.refreshManager = refreshManager;
    }

    @Override
    public boolean hasRepositoryPath(String jiraProjectKey) {
        Optional<Long> jiraProjectId = this.getProjectId(jiraProjectKey);
        return jiraProjectId.isPresent() && this.jiraProjectIdToRepositoryPathMap.containsKey(jiraProjectId.get());
    }

    private Optional<Long> getProjectId(String jiraProjectKey) {
        Project project = this.projectManager.getProjectObjByKey(jiraProjectKey);
        if (project == null) {
            return Optional.absent();
        }
        return Optional.of((Object)project.getId());
    }

    @Override
    @Nullable
    public RepositoryPath getRepositoryPath(String jiraProjectKey) {
        Optional<Long> jiraProjectId = this.getProjectId(jiraProjectKey);
        if (jiraProjectId.isPresent()) {
            return this.jiraProjectIdToRepositoryPathMap.get(jiraProjectId.get());
        }
        return null;
    }

    @Override
    public void updateRepositoryPath(final String jiraProjectKeyToUpdate, final RepositoryPath repositoryPath) {
        this.forEachApplicationLink(new Closure(){

            @Override
            public void with(ApplicationLink applicationLink) {
                HashSet jiraProjectKeys = Sets.newHashSet((Iterable)JIRA_PROJECT_WITH_PATH_PROPERTY.get(applicationLink));
                if (!jiraProjectKeys.contains(jiraProjectKeyToUpdate)) {
                    jiraProjectKeys.add(jiraProjectKeyToUpdate);
                    RepositoryPathStoreImpl.this.setProjectsWithPaths(applicationLink, jiraProjectKeys);
                }
                ProjectKey.JIRA jiraProjectToUpdate = new ProjectKey.JIRA(jiraProjectKeyToUpdate);
                FISHEYE_REPOSITORY_WITH_PATH_PROPERTY.set(applicationLink, jiraProjectToUpdate, repositoryPath.getRep().getName());
                PATH_PROPERTY.set(applicationLink, jiraProjectToUpdate, repositoryPath.getPath());
            }
        });
    }

    @Override
    public Map<String, RepositoryPath> getRepositoryPaths() {
        HashMap<String, RepositoryPath> repositoryPaths = new HashMap<String, RepositoryPath>();
        for (Map.Entry<Long, RepositoryPath> entry : this.jiraProjectIdToRepositoryPathMap.entrySet()) {
            Project jiraProject = this.projectManager.getProjectObj(entry.getKey());
            repositoryPaths.put(jiraProject.getKey(), entry.getValue());
        }
        return repositoryPaths;
    }

    @Override
    public void removeRepositoryPath(final String jiraProjectKeyToRemove) {
        this.forEachApplicationLink(new Closure(){

            @Override
            public void with(ApplicationLink applicationLink) {
                Object jiraProjectkeys = JIRA_PROJECT_WITH_PATH_PROPERTY.get(applicationLink);
                RepositoryPathStoreImpl.this.setProjectsWithPaths(applicationLink, Collections2.filter((Collection)jiraProjectkeys, (Predicate)new Predicate<String>(){

                    public boolean apply(String existingJiraProjectKey) {
                        return !existingJiraProjectKey.equals(jiraProjectKeyToRemove);
                    }
                }));
                ProjectKey.JIRA jiraProject = new ProjectKey.JIRA(jiraProjectKeyToRemove);
                FISHEYE_REPOSITORY_WITH_PATH_PROPERTY.remove(applicationLink, jiraProject);
                PATH_PROPERTY.remove(applicationLink, jiraProject);
            }
        });
    }

    protected void setProjectsWithPaths(ApplicationLink applicationLink, Collection<String> projectsWithPaths) {
        JIRA_PROJECT_WITH_PATH_PROPERTY.set(applicationLink, projectsWithPaths);
    }

    @Override
    public void reloadRepositoryPaths() {
        this.jiraProjectIdToRepositoryPathMap.clear();
        this.forEachApplicationLink(new Closure(){

            @Override
            public void with(ApplicationLink applicationLink) {
                Collection jiraProjectKeys = Collections2.transform((Collection)JIRA_PROJECT_WITH_PATH_PROPERTY.get(applicationLink), (Function)new Function<String, ProjectKey.JIRA>(){

                    public ProjectKey.JIRA apply(String jiraprojectKeyString) {
                        return new ProjectKey.JIRA(jiraprojectKeyString);
                    }
                });
                for (ProjectKey.JIRA jiraProjectKey : jiraProjectKeys) {
                    Object repositoryName = FISHEYE_REPOSITORY_WITH_PATH_PROPERTY.get(applicationLink, jiraProjectKey);
                    Object path = PATH_PROPERTY.get(applicationLink, jiraProjectKey);
                    FishEyeRepository repository = RepositoryPathStoreImpl.this.repositoryStore.getRepository((String)repositoryName, applicationLink.getId());
                    if (repository != null && path != null) {
                        Optional jiraProjectId = RepositoryPathStoreImpl.this.getProjectId(jiraProjectKey.getKey());
                        if (jiraProjectId.isPresent()) {
                            RepositoryPathStoreImpl.this.jiraProjectIdToRepositoryPathMap.put((Long)jiraProjectId.get(), new RepositoryPath(repository, (String)path));
                            continue;
                        }
                        log.info(String.format("Cannot find project with key: %s. Looks like it was deleted.", jiraProjectKey.getKey()));
                        continue;
                    }
                    log.error(String.format("Cannot find configured repository for jira project %s: applicationLink=[%s] repositoryName=[%s] path=[%s]", jiraProjectKey.getKey(), applicationLink, repositoryName, path));
                }
            }
        });
    }

    private void forEachApplicationLink(Closure closure) {
        for (ApplicationLink applicationLink : this.applicationLinkService.getApplicationLinks(FishEyeCrucibleApplicationType.class)) {
            closure.with(applicationLink);
        }
    }

    @Override
    public void refresh() {
        this.reloadRepositoryPaths();
    }

    @Override
    public int order() {
        return 40;
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshManager.registerRefreshable(this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        this.reloadRepositoryPaths();
    }

    private static interface Closure {
        public void with(ApplicationLink var1);
    }
}

