/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.fisheye;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeRepositoryEntityType;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jirafisheyeplugin.config.JiraProjectKeyToIdConverter;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.Refreshable;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.config.properties.CollectionApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.config.properties.CollectionProjectProperty;
import com.atlassian.jirafisheyeplugin.config.properties.ProjectKey;
import com.atlassian.jirafisheyeplugin.config.properties.converters.StringIdentityConverter;
import com.atlassian.jirafisheyeplugin.config.ual.UalUtil;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepositoryImpl;
import com.atlassian.jirafisheyeplugin.util.Util;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FishEyeRepositoryStoreImpl
implements FishEyeRepositoryStore,
FishEyePropertyKeys,
Refreshable,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(FishEyeRepositoryStoreImpl.class);
    private final CollectionApplicationLinkProperty<String> repositoryListProperty = new CollectionApplicationLinkProperty<String>("fisheye.repository.list", new StringIdentityConverter());
    private final EntityLinkService entityLinkService;
    private final FishEyeProperties properties;
    private final FishEyeInstanceStore instanceStore;
    private final JiraAuthenticationContext authenticationContext;
    private final RefreshManager refreshManager;
    private final ApplicationLinkService applicationLinkService;
    private final ProjectManager projectManager;
    private final Set<FishEyeRepository> repositories = new CopyOnWriteArraySet<FishEyeRepository>();
    private final Map<Long, Set<FishEyeRepository>> projectRepositories = new ConcurrentHashMap<Long, Set<FishEyeRepository>>();
    private final CollectionProjectProperty<ProjectKey.FISHEYE_REPO, Long> repositoryProjectsProperty;

    public FishEyeRepositoryStoreImpl(EntityLinkService entityLinkService, FishEyeProperties properties, FishEyeInstanceStore instanceStore, JiraAuthenticationContext authenticationContext, RefreshManager refreshManager, ApplicationLinkService applicationLinkService, ProjectManager projectManager) {
        this.entityLinkService = entityLinkService;
        this.properties = properties;
        this.instanceStore = instanceStore;
        this.authenticationContext = authenticationContext;
        this.refreshManager = refreshManager;
        this.applicationLinkService = applicationLinkService;
        this.projectManager = projectManager;
        this.repositoryProjectsProperty = new CollectionProjectProperty("fisheye.rep.", ".projects", new JiraProjectKeyToIdConverter(projectManager));
    }

    @Override
    public List<FishEyeRepository> getRepositoriesForJiraProjectKey(final String repositoryName, String jiraProjectKey) {
        Iterable<FishEyeRepository> ualConfiguredEntities = this.getAllLinkedRepositoriesForJiraProjectKey(jiraProjectKey);
        if (StringUtils.isEmpty(repositoryName) && ualConfiguredEntities.iterator().hasNext()) {
            return Lists.newArrayList(ualConfiguredEntities);
        }
        ArrayList results = Lists.newArrayList();
        Iterable applicationLinks = this.applicationLinkService.getApplicationLinks(FishEyeCrucibleApplicationType.class);
        Iterable aggregatedRepositoriesList = Iterables.transform((Iterable)applicationLinks, (Function)new Function<ApplicationLink, Iterable<FishEyeRepository>>(){

            public Iterable<FishEyeRepository> apply(final ApplicationLink link) {
                Iterable filteredRepositoryNames = Iterables.filter((Iterable)FishEyeRepositoryStoreImpl.this.repositoryListProperty.get(link), (Predicate)new Predicate<String>(){

                    public boolean apply(String repositoryNameFromApplicationLink) {
                        return repositoryNameFromApplicationLink.equals(repositoryName);
                    }
                });
                return Iterables.transform((Iterable)filteredRepositoryNames, (Function)new Function<String, FishEyeRepository>(){

                    public FishEyeRepository apply(String repositoryName) {
                        return FishEyeRepositoryStoreImpl.this.createRepository(link.getId(), link, repositoryName);
                    }
                });
            }
        });
        for (Iterable aggregatedRepositories : aggregatedRepositoriesList) {
            results.addAll(Lists.newArrayList((Iterable)aggregatedRepositories));
        }
        return results;
    }

    @VisibleForTesting
    protected Iterable<FishEyeRepository> getAllLinkedRepositoriesForJiraProjectKey(String jiraProjectKey) {
        Project project = this.projectManager.getProjectObjByKey(jiraProjectKey);
        if (project != null) {
            return Iterables.transform((Iterable)this.entityLinkService.getEntityLinks((Object)project, FishEyeRepositoryEntityType.class), (Function)new Function<EntityLink, FishEyeRepository>(){

                public FishEyeRepository apply(EntityLink entityLink) {
                    return FishEyeRepositoryStoreImpl.this.createRepository(entityLink);
                }
            });
        }
        return Collections.emptyList();
    }

    private FishEyeRepository createRepository(EntityLink link) {
        return this.createRepository(link.getApplicationLink().getId(), link.getApplicationLink(), link.getKey());
    }

    private FishEyeRepository createRepository(ApplicationId applicationId, ApplicationLink link, String name) {
        return new FishEyeRepositoryImpl(this.instanceStore.getFishEyeInstance(applicationId), name, (Collection<Long>)this.repositoryProjectsProperty.get(link, (ProjectKey)new ProjectKey.FISHEYE_REPO(name)));
    }

    @Override
    public FishEyeRepository getRepository(final String repositoryName, ApplicationId fisheyeInstanceId) {
        ApplicationLink applicationLink = UalUtil.idToLink(this.applicationLinkService, fisheyeInstanceId);
        Iterable filtered = Iterables.filter((Iterable)this.repositoryListProperty.get(applicationLink), (Predicate)new Predicate<String>(){

            public boolean apply(String storedRepositoryName) {
                return storedRepositoryName.equals(repositoryName);
            }
        });
        if (filtered.iterator().hasNext()) {
            return this.createRepository(fisheyeInstanceId, applicationLink, (String)filtered.iterator().next());
        }
        log.debug(String.format("FishEyeRepositoryStoreImpl.getRepository() : Repository [%s] not found in applicationlink [%s]", repositoryName, fisheyeInstanceId));
        return null;
    }

    @Override
    public boolean isMapped(String jiraProjectKey) {
        Set<FishEyeRepository> repositories = this.getFishEyeRepositories(jiraProjectKey);
        return repositories != null && !repositories.isEmpty();
    }

    @Override
    public Set<FishEyeRepository> getRepositories(String jiraProjectKey) {
        Set<FishEyeRepository> applicableRepositories = this.getFishEyeRepositories(jiraProjectKey);
        if (applicableRepositories == null) {
            applicableRepositories = this.repositories;
        }
        return new HashSet<FishEyeRepository>(applicableRepositories);
    }

    private Set<FishEyeRepository> getFishEyeRepositories(String jiraProjectKey) {
        Long jiraProjectId = this.getProjectId(jiraProjectKey);
        return this.projectRepositories.get(jiraProjectId);
    }

    private Set<FishEyeRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    public Set<FishEyeRepository> getDefaultRepositories() {
        return this.getRepositoriesForInstance(this.instanceStore.getDefaultFishEyeInstance().getApplicationId());
    }

    @Override
    public Set<FishEyeRepository> getRepositoriesForInstance(ApplicationId fisheyeInstanceId) {
        return this.deserialiseRepositories(fisheyeInstanceId);
    }

    @Override
    public void setRepositoriesForInstance(Set<FishEyeRepository> reps, ApplicationId fisheyeInstanceId) {
        this.serialiseRepositories(reps, fisheyeInstanceId);
        this.setRepoLastUpdatedTime();
        this.reloadRepositories();
    }

    private void setRepoLastUpdatedTime() {
        this.properties.setString("fisheye.repository.last.updated", Util.formatDate("EEE, d MMM yyyy HH:mm:ss Z", new Date(), this.authenticationContext.getLocale()));
    }

    private Set<FishEyeRepository> deserialiseRepositories(ApplicationId fisheyeInstanceId) {
        ApplicationLink link = UalUtil.idToLink(this.applicationLinkService, fisheyeInstanceId);
        if (link == null) {
            return Collections.emptySet();
        }
        Object repositoryNames = this.repositoryListProperty.get(link);
        LinkedHashSet<FishEyeRepository> repositories = new LinkedHashSet<FishEyeRepository>();
        FishEyeInstance instance = this.instanceStore.getFishEyeInstance(fisheyeInstanceId);
        if (instance == null) {
            log.error(String.format("Could not retrieve deserialise repositories for unconfigured FishEye instance (id=%s)", fisheyeInstanceId));
            return repositories;
        }
        Iterator iterator = repositoryNames.iterator();
        while (iterator.hasNext()) {
            String repositoryName = (String)iterator.next();
            Object repProjectMappings = this.repositoryProjectsProperty.get(link, (ProjectKey)new ProjectKey.FISHEYE_REPO(repositoryName));
            repositories.add(new FishEyeRepositoryImpl(instance, repositoryName, (Collection<Long>)repProjectMappings));
        }
        return repositories;
    }

    private void serialiseRepositories(Set<FishEyeRepository> repositories, ApplicationId fisheyeInstanceId) {
        if (repositories == null) {
            return;
        }
        ApplicationLink link = UalUtil.idToLink(this.applicationLinkService, fisheyeInstanceId);
        for (FishEyeRepository oldRepository : this.getRepositories()) {
            ProjectKey.FISHEYE_REPO repo = new ProjectKey.FISHEYE_REPO(oldRepository.getName());
            this.repositoryProjectsProperty.remove(link, (ProjectKey.FISHEYE_REPO)((Object)((Long)((Object)repo))));
        }
        this.repositoryListProperty.remove(link);
        this.repositoryListProperty.set(link, Collections2.transform(repositories, (Function)new Function<FishEyeRepository, String>(){

            public String apply(FishEyeRepository rep) {
                return rep.getName();
            }
        }));
        for (FishEyeRepository repository : repositories) {
            Collection<Long> mappedProjects = repository.getMappedProjectIds();
            if (mappedProjects == null || mappedProjects.isEmpty()) continue;
            this.repositoryProjectsProperty.set(link, new ProjectKey.FISHEYE_REPO(repository.getName()), mappedProjects);
        }
    }

    private void reloadRepositories() {
        log.info("Reloading repositories");
        this.repositories.clear();
        for (FishEyeInstance fe : this.instanceStore.getAllFishEyeInstances()) {
            if (fe.isCruStandalone()) continue;
            this.repositories.addAll(this.deserialiseRepositories(fe.getApplicationId()));
        }
        this.projectRepositories.clear();
        for (FishEyeRepository rep : this.repositories) {
            for (Long projectId : rep.getMappedProjectIds()) {
                Set<FishEyeRepository> projectReps = this.projectRepositories.get(projectId);
                if (projectReps == null) {
                    projectReps = new HashSet<FishEyeRepository>();
                }
                projectReps.add(rep);
                this.projectRepositories.put(projectId, projectReps);
            }
        }
    }

    @Override
    public void deleteRepositoriesForInstance(FishEyeInstance instance) {
        this.serialiseRepositories(Collections.emptySet(), instance.getApplicationId());
    }

    @Override
    public void associateProjectWithRepository(Long projectId, String repositoryName, ApplicationId fisheyeInstanceId) {
        ProjectKey.FISHEYE_REPO repo;
        ApplicationLink link = UalUtil.idToLink(this.applicationLinkService, fisheyeInstanceId);
        Object projectIds = this.repositoryProjectsProperty.get(link, (ProjectKey)(repo = new ProjectKey.FISHEYE_REPO(repositoryName)));
        if (projectIds.contains(projectId)) {
            return;
        }
        projectIds.add(projectId);
        this.repositoryProjectsProperty.set(link, repo, (Collection<Long>)projectIds);
        this.reloadRepositories();
    }

    private Long getProjectId(String projectKey) {
        return this.projectManager.getProjectObjByKey(projectKey).getId();
    }

    @Override
    public void addRepositories(Set<String> repositoryNames, ApplicationId fisheyeInstanceId) {
        ApplicationLink link = UalUtil.idToLink(this.applicationLinkService, fisheyeInstanceId);
        HashSet<String> storedNames = new HashSet<String>((Collection<String>)this.repositoryListProperty.get(link));
        storedNames.addAll(repositoryNames);
        this.repositoryListProperty.set(link, (Collection<String>)storedNames);
        this.reloadRepositories();
        this.setRepoLastUpdatedTime();
    }

    @Override
    public String getRepoListLastUpdatedTime() {
        return this.properties.getString("fisheye.repository.last.updated");
    }

    @Override
    public void refresh() {
        this.reloadRepositories();
    }

    @Override
    public int order() {
        return 30;
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshManager.registerRefreshable(this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        this.refresh();
    }
}

