/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.fisheye;

import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryManager;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeRepositoryManagerImpl
implements FishEyeRepositoryManager {
    private static final Logger log = LoggerFactory.getLogger(FishEyeRepositoryManagerImpl.class);
    private final FishEyeRepositoryStore fishEyeRepositoryStore;

    public FishEyeRepositoryManagerImpl(FishEyeRepositoryStore fishEyeRepositoryStore) {
        this.fishEyeRepositoryStore = fishEyeRepositoryStore;
    }

    @Override
    public List<FishEyeRepository> load(FishEyeInstance fishEyeInstance) {
        return Lists.newArrayList(this.fishEyeRepositoryStore.getRepositoriesForInstance(fishEyeInstance.getApplicationId()));
    }

    @Override
    public FishEyeRepository load(FishEyeInstance fishEyeInstance, String repositoryName) {
        return this.fishEyeRepositoryStore.getRepository(repositoryName, fishEyeInstance.getApplicationId());
    }

    @Override
    public FishEyeRepository update(final FishEyeRepository fishEyeRepository) {
        Set<FishEyeRepository> currentRepos = this.fishEyeRepositoryStore.getRepositoriesForInstance(fishEyeRepository.getInstance().getApplicationId());
        HashSet newRepos = Sets.newHashSet((Iterable)Collections2.filter(currentRepos, (Predicate)new Predicate<FishEyeRepository>(){

            public boolean apply(FishEyeRepository input) {
                return !fishEyeRepository.getName().equals(input.getName());
            }
        }));
        newRepos.add(fishEyeRepository);
        this.fishEyeRepositoryStore.setRepositoriesForInstance(newRepos, fishEyeRepository.getInstance().getApplicationId());
        return fishEyeRepository;
    }
}

