/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.fisheye;

import com.atlassian.jirafisheyeplugin.config.PropertySetHolder;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyePropertiesImpl
implements FishEyeProperties {
    private static Logger log = LoggerFactory.getLogger(FishEyePropertiesImpl.class);
    private static final Long FALSE = new Long(0L);
    private static final Long TRUE = new Long(1L);
    private final PropertySetHolder factory;

    public FishEyePropertiesImpl(PropertySetHolder factory) {
        this.factory = factory;
    }

    @Override
    public String getText(String key) {
        String value = this.getPropertySet().getText(key);
        if (!TextUtils.stringSet((String)value)) {
            return null;
        }
        return value;
    }

    @Override
    public void setText(String key, String value) {
        if (!TextUtils.stringSet((String)value)) {
            this.removeProperty(key);
        } else {
            this.getPropertySet().setText(key, value);
        }
    }

    @Override
    public String getString(String key) {
        String value = this.getPropertySet().getString(key);
        if (!TextUtils.stringSet((String)value)) {
            return null;
        }
        return value;
    }

    @Override
    public void setString(String key, String value) {
        if (!TextUtils.stringSet((String)value)) {
            this.removeProperty(key);
        } else {
            this.getPropertySet().setString(key, value);
        }
    }

    @Override
    public void removeProperty(String key) {
        if (this.getPropertySet().exists(key)) {
            this.getPropertySet().remove(key);
        }
    }

    @Override
    public void setLong(String key, Long value) {
        this.setString(key, value == null ? null : value.toString());
    }

    @Override
    public Long getLong(String key) {
        String property = this.getString(key);
        if (property == null) {
            return null;
        }
        try {
            return new Long(property);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Property " + key + " must be a valid integer. Found '" + property + "'");
        }
    }

    @Override
    public Boolean getBoolean(String key) {
        Long longValue = this.getLong(key);
        if (longValue == null) {
            return null;
        }
        return longValue.intValue() > 0;
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        if (value == null) {
            this.removeProperty(key);
            return;
        }
        this.setLong(key, value != false ? TRUE : FALSE);
    }

    @Override
    public boolean getBooleanPrimitive(String key) {
        Boolean bool = this.getBoolean(key);
        return bool != null && bool != false;
    }

    protected PropertySet getPropertySet() {
        return this.factory.get();
    }

    public static String updateKey(String propertyKey, String projectKey) {
        return propertyKey.replaceAll("%PRJ%", projectKey);
    }

    @Override
    public Collection<String> parseCollection(String text) {
        TreeSet<String> collection = new TreeSet<String>();
        if (text == null) {
            return collection;
        }
        StringTokenizer toks = new StringTokenizer(text, ", ");
        while (toks.hasMoreTokens()) {
            collection.add(toks.nextToken());
        }
        return collection;
    }

    @Override
    public Map parseMap(String text) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (text == null) {
            return map;
        }
        StringTokenizer toks = new StringTokenizer(text, ",");
        while (toks.hasMoreTokens()) {
            String key = toks.nextToken();
            if (!toks.hasMoreTokens()) {
                log.error("Supplied text '" + text + "' has uneven number of delimited elements - not suitable for Map");
                return map;
            }
            String value = toks.nextToken();
            map.put(key, value);
        }
        return map;
    }

    @Override
    public String serialiseCollection(Collection c) {
        StringBuilder buff = new StringBuilder();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            buff.append(o.toString());
            if (!iterator.hasNext()) continue;
            buff.append(", ");
        }
        return buff.toString();
    }

    @Override
    public String serialiseMap(Map m) {
        StringBuilder buff = new StringBuilder();
        Iterator iterator = m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            if (e.getKey() == null || e.getValue() == null) {
                log.error("Cannot serialise (null key/value) entry=[" + e.getKey() + ":" + e.getValue() + "]");
                continue;
            }
            buff.append(e.getKey().toString()).append(",").append(e.getValue().toString());
            if (!iterator.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    @Override
    public Collection<String> getCollection(String key) {
        return this.parseCollection(this.getText(key));
    }

    @Override
    public void setCollection(String key, Collection collection) {
        this.setText(key, this.serialiseCollection(collection));
    }

    @Override
    public Map getMap(String key) {
        return this.parseMap(this.getText(key));
    }

    @Override
    public void setMap(String key, Map map) {
        this.setText(key, this.serialiseMap(map));
    }

    @Override
    public void refresh() {
        this.factory.reset();
    }
}

