/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.fisheye;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.Refreshable;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.config.properties.BooleanApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.config.properties.EnumApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.config.properties.IntegerApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.config.properties.StringApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.config.ual.UalUtil;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstanceImpl;
import com.atlassian.jirafisheyeplugin.util.ConfigUtil;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FishEyeInstanceStoreImpl
implements FishEyeInstanceStore,
FishEyePropertyKeys,
Refreshable,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(FishEyeInstanceStoreImpl.class);
    private static final StringApplicationLinkProperty FISHEYE_CHARSET_PROPERTY = new StringApplicationLinkProperty("fisheye.charset");
    private static final IntegerApplicationLinkProperty FISHEYE_SOCK_TIMEOUT_PROPERTY = new IntegerApplicationLinkProperty("fisheye.api.socket.timeout");
    private static final IntegerApplicationLinkProperty FISHEYE_CONN_TIMEOUT_PROPERTY = new IntegerApplicationLinkProperty("fisheye.api.connection.timeout");
    private static final EnumApplicationLinkProperty<CrucibleEnabledState> FISHEYE_CRUCIBLE_ENABLED_PROPERTY = new EnumApplicationLinkProperty<CrucibleEnabledState>("fisheye.crucible.enabled", CrucibleEnabledState.class, CrucibleEnabledState.ENABLED);
    private static final BooleanApplicationLinkProperty FISHEYE_INITIALISED_PROPERTY = new BooleanApplicationLinkProperty("fisheye.refreshed");
    private final ApplicationLinkService applicationLinkService;
    private final ConfigUtil configUtil;
    private final RefreshManager refreshManager;
    private Map<String, FishEyeInstance> instancesByUrl;
    private List<FishEyeInstance> cruStandaloneInstances;
    private Map<ApplicationId, FishEyeInstance> loadedInstances = new HashMap<ApplicationId, FishEyeInstance>();

    public FishEyeInstanceStoreImpl(ApplicationLinkService applicationLinkService, ConfigUtil configUtil, RefreshManager refreshManager) {
        this.applicationLinkService = applicationLinkService;
        this.configUtil = configUtil;
        this.refreshManager = refreshManager;
    }

    @Override
    public FishEyeInstance getDefaultFishEyeInstance() {
        ApplicationLink primaryApplicationLink = this.applicationLinkService.getPrimaryApplicationLink(FishEyeCrucibleApplicationType.class);
        if (primaryApplicationLink != null) {
            return this.getFishEyeInstance(primaryApplicationLink);
        }
        Iterator<ApplicationLink> otherApplicationLinks = this.getAllFisheyeApplicationLinks().iterator();
        if (otherApplicationLinks.hasNext()) {
            return this.getFishEyeInstance(otherApplicationLinks.next());
        }
        return null;
    }

    @Override
    public void addFishEyeInstance(FishEyeInstance instance) {
        if (Collections2.transform(this.getAllFishEyeInstances(), (Function)new Function<FishEyeInstance, String>(){

            public String apply(FishEyeInstance from) {
                return from.getUrl();
            }
        }).contains(instance.getUrl())) {
            throw new IllegalArgumentException(String.format("Cannot add an instance that already exists: trying to add [%s], but the url already exists", instance));
        }
        this.storeFishEyeInstance(instance);
    }

    @Override
    public void updateFishEyeInstance(FishEyeInstance instance) {
        this.storeFishEyeInstance(instance);
    }

    void storeFishEyeInstance(FishEyeInstance instance) {
        ApplicationLink link = UalUtil.idToLink(this.applicationLinkService, instance.getApplicationId());
        if (instance.getCharset() != null) {
            FISHEYE_CHARSET_PROPERTY.set(link, instance.getCharset().name());
        } else {
            FISHEYE_CHARSET_PROPERTY.remove(link);
        }
        FISHEYE_SOCK_TIMEOUT_PROPERTY.set(link, instance.getSocketTimeout());
        FISHEYE_CONN_TIMEOUT_PROPERTY.set(link, instance.getConnectionTimeout());
        FISHEYE_CRUCIBLE_ENABLED_PROPERTY.set(link, this.computeCrucibleState(instance));
        FISHEYE_INITIALISED_PROPERTY.set(link, instance.isHasBeenInitialised());
        this.loadedInstances.put(link.getId(), instance);
    }

    private CrucibleEnabledState computeCrucibleState(FishEyeInstance instance) {
        return instance.isCruStandalone() ? CrucibleEnabledState.STANDALONE : (instance.isCru() ? CrucibleEnabledState.ENABLED : CrucibleEnabledState.DISABLED);
    }

    @Override
    public FishEyeInstance getFishEyeInstance(ApplicationId id) {
        ApplicationLink link = UalUtil.idToLink(this.applicationLinkService, id);
        return this.getFishEyeInstance(link);
    }

    private FishEyeInstance getFishEyeInstance(ApplicationLink link) {
        if (!this.isFisheyeInstanceInitialized(link)) {
            return null;
        }
        FishEyeInstance instance = this.loadedInstances.get(link.getId());
        if (instance == null) {
            boolean isCru = false;
            boolean isCruStandalone = false;
            CrucibleEnabledState cru = (CrucibleEnabledState)((Object)FISHEYE_CRUCIBLE_ENABLED_PROPERTY.get(link));
            if (cru != null) {
                switch (cru) {
                    case STANDALONE: {
                        isCruStandalone = true;
                    }
                    case ENABLED: {
                        isCru = true;
                        break;
                    }
                }
            }
            instance = new FishEyeInstanceImpl(link.getName(), isCru, isCruStandalone, link.getDisplayUrl().toString(), link.getRpcUrl().toString(), this.configUtil.resolveCharset(FISHEYE_CHARSET_PROPERTY.get(link)), this.configUtil.retrieveValidatedIntWithServerId(FISHEYE_SOCK_TIMEOUT_PROPERTY, 10000, link), this.configUtil.retrieveValidatedIntWithServerId(FISHEYE_CONN_TIMEOUT_PROPERTY, 10000, link), link.getId(), true);
            this.loadedInstances.put(link.getId(), instance);
        }
        return instance;
    }

    private boolean isFisheyeInstanceInitialized(ApplicationLink link) {
        return link != null && FISHEYE_INITIALISED_PROPERTY.get(link) != false;
    }

    @Override
    public List<FishEyeInstance> getAuxiliaryFishEyeInstances() {
        Iterable<ApplicationLink> links = this.getAllFisheyeApplicationLinks();
        ArrayList<ApplicationLink> auxLinks = new ArrayList<ApplicationLink>();
        for (ApplicationLink l : links) {
            if (l.isPrimary()) continue;
            auxLinks.add(l);
        }
        return this.getFishEyeInstances(auxLinks);
    }

    @Override
    public List<FishEyeInstance> getAllFishEyeInstances() {
        return this.getFishEyeInstances(this.getAllFisheyeApplicationLinks());
    }

    private List<FishEyeInstance> getFishEyeInstances(Iterable<ApplicationLink> links) {
        ArrayList<FishEyeInstance> instances = new ArrayList<FishEyeInstance>();
        for (ApplicationLink link : links) {
            FishEyeInstance instance = this.getFishEyeInstance(link);
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    private Iterable<ApplicationLink> getAllFisheyeApplicationLinks() {
        return this.applicationLinkService.getApplicationLinks(FishEyeCrucibleApplicationType.class);
    }

    @Override
    public FishEyeInstance getFishEyeInstanceByUrl(String url) {
        if (url == null) {
            return null;
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (this.instancesByUrl == null) {
            this.instancesByUrl = new HashMap<String, FishEyeInstance>();
            for (FishEyeInstance instance : this.getAllFishEyeInstances()) {
                this.instancesByUrl.put(instance.getUrl(), instance);
            }
        }
        return this.instancesByUrl.get(url);
    }

    @Override
    public void refresh() {
        this.loadedInstances.clear();
        this.cruStandaloneInstances = null;
        this.instancesByUrl = null;
    }

    @Override
    public synchronized Collection<FishEyeInstance> getCrucibleStandaloneInstances() {
        if (this.cruStandaloneInstances == null) {
            this.cruStandaloneInstances = new ArrayList<FishEyeInstance>();
            for (FishEyeInstance fe : this.getAllFishEyeInstances()) {
                if (!fe.isCruStandalone()) continue;
                this.cruStandaloneInstances.add(fe);
            }
        }
        return this.cruStandaloneInstances;
    }

    @Override
    public int order() {
        return 20;
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshManager.registerRefreshable(this);
    }

    public static enum CrucibleEnabledState {
        ENABLED,
        STANDALONE,
        DISABLED;

    }
}

