/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.fisheye;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceManager;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstanceImpl;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ServerInfo;
import com.atlassian.jirafisheyeplugin.exceptions.OAuthNotAuthorisedException;
import com.atlassian.jirafisheyeplugin.rest.FishEyeRestApiManager;
import com.atlassian.jirafisheyeplugin.rest.command.RestCommand;
import com.atlassian.jirafisheyeplugin.rest.command.RestCommandFactory;
import com.atlassian.jirafisheyeplugin.rest.response.FishEyeDocumentHolder;
import com.atlassian.jirafisheyeplugin.rest.response.ResponseParser;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeInstanceManagerImpl
implements FishEyeInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(FishEyeInstanceManagerImpl.class);
    private final FishEyeInstanceStore fishEyeInstanceStore;
    private final FishEyeManager fishEyeManager;
    private final FishEyeRepositoryStore fishEyeRepositoryStore;
    private final CrucibleProjectStore crucibleProjectStore;
    private final RefreshManager refreshManager;
    private ApplicationLinkService applicationLinkService;
    private FishEyeRestApiManager fishEyeRestApiManager;

    public FishEyeInstanceManagerImpl(FishEyeInstanceStore fishEyeInstanceStore, FishEyeManager fishEyeManager, FishEyeRepositoryStore fishEyeRepositoryStore, CrucibleProjectStore crucibleProjectStore, RefreshManager refreshManager, ApplicationLinkService applicationLinkService, FishEyeRestApiManager fishEyeRestApiManager) {
        this.fishEyeInstanceStore = fishEyeInstanceStore;
        this.fishEyeManager = fishEyeManager;
        this.fishEyeRepositoryStore = fishEyeRepositoryStore;
        this.crucibleProjectStore = crucibleProjectStore;
        this.refreshManager = refreshManager;
        this.applicationLinkService = applicationLinkService;
        this.fishEyeRestApiManager = fishEyeRestApiManager;
    }

    @Override
    public FishEyeInstance create(ApplicationLink applicationLink) {
        if (!(applicationLink.getType() instanceof FishEyeCrucibleApplicationType)) {
            throw new IllegalArgumentException(String.format("The application link '%s' does not point to a FishEye/Crucible instance", applicationLink.getName()));
        }
        FishEyeInstance instance = this.load(applicationLink.getId());
        if (instance != null) {
            throw new IllegalArgumentException(String.format("There is already a FishEyeInstance with applicationId=%s: %s", applicationLink.getId(), instance));
        }
        ServerInfo serverInfo = this.fetchServerInfo(applicationLink);
        instance = new FishEyeInstanceImpl(applicationLink.getName(), serverInfo.isCrucible(), serverInfo.isCrucibleStandalone(), applicationLink.getDisplayUrl().toString(), applicationLink.getRpcUrl().toString(), null, 10000, 10000, applicationLink.getId(), true);
        this.fishEyeInstanceStore.addFishEyeInstance(instance);
        this.fetchRepositoryAndProjectLists(instance);
        this.fishEyeInstanceStore.updateFishEyeInstance(instance);
        this.fishEyeManager.refreshConfig();
        return instance;
    }

    @Override
    public int getVersionNumber(FishEyeInstance instance) {
        ServerInfo serverInfo;
        ApplicationLink applicationLink;
        try {
            applicationLink = this.applicationLinkService.getApplicationLink(instance.getApplicationId());
            if (applicationLink == null) {
                return -1;
            }
        }
        catch (TypeNotInstalledException e) {
            throw new RuntimeException(String.format("The application link '%s' has an invalid type", instance.getApplicationId()), e);
        }
        RestCommand<ServerInfo> serverInfoCmd = RestCommandFactory.serverInfo();
        URI url = serverInfoCmd.makeAbsoluteURL(applicationLink.getRpcUrl().toString());
        try {
            List<ServerInfo> serverInfos = this.fishEyeRestApiManager.callFisheye(instance, serverInfoCmd, new ResponseParser<ServerInfo>(){

                @Override
                public List<ServerInfo> parse(FishEyeDocumentHolder doc) throws IOException {
                    return Lists.newArrayList((Object[])new ServerInfo[]{ServerInfo.fromDocument(doc.getDoc())});
                }
            });
            serverInfo = serverInfos.get(0);
        }
        catch (OAuthNotAuthorisedException e) {
            return -1;
        }
        catch (IOException e) {
            log.debug("Failed to get server info from FishEye. It will be treated as 2.9.0 or later. Url = " + url, (Throwable)e);
            return -1;
        }
        return serverInfo.getVersion();
    }

    @Override
    public void fetchRepositoryAndProjectLists(FishEyeInstance instance) {
        log.debug("Fetching repository and project lists from '{}'", (Object)instance.getName());
        this.refreshManager.refreshAll();
    }

    @Override
    public FishEyeInstance load(ApplicationId applicationId) {
        return this.fishEyeInstanceStore.getFishEyeInstance(applicationId);
    }

    @Override
    public void delete(FishEyeInstance fishEyeInstance) {
        this.crucibleProjectStore.clearProjectMappingsForInstance(fishEyeInstance.getApplicationId());
        this.fishEyeRepositoryStore.deleteRepositoriesForInstance(fishEyeInstance);
        this.fishEyeManager.refreshConfig();
    }

    @Override
    public void update(FishEyeInstance updatedFishEyeInstance) {
        this.fishEyeInstanceStore.updateFishEyeInstance(updatedFishEyeInstance);
        this.fishEyeManager.refreshConfig();
    }

    @Override
    public ServerInfo fetchServerInfo(ApplicationLink applicationLink) {
        log.debug("Attempting to fetch server info for '{}'", (Object)applicationLink.getName());
        RestCommand<ServerInfo> serverInfoCmd = RestCommandFactory.serverInfo();
        URI url = serverInfoCmd.makeAbsoluteURL(applicationLink.getRpcUrl().toString());
        boolean isCrucibleStandalone = this.anonymousRequestReturns404(applicationLink, serverInfoCmd);
        if (isCrucibleStandalone) {
            log.debug("Request to '{}' returned 404. Assuming Crucible standalone", (Object)url);
            return ServerInfo.crucibleStandalone();
        }
        try {
            return this.doAuthenticatedRequest(applicationLink, serverInfoCmd);
        }
        catch (CredentialsRequiredException e) {
            log.warn(String.format("Request to '%s' failed due to missing OAuth credentials. Assuming FishEye+Crucible both available", url), (Throwable)e);
            return ServerInfo.fisheyeAndCrucible();
        }
        catch (ResponseException e) {
            log.warn(String.format("Request to '%s' failed. Assuming FishEye+Crucible both available", url), (Throwable)e);
            return ServerInfo.fisheyeAndCrucible();
        }
    }

    protected boolean anonymousRequestReturns404(ApplicationLink applicationLink, RestCommand command) {
        String url = command.makeAbsoluteURL(applicationLink.getRpcUrl()).toString();
        Request request = Anonymous.createAnonymousRequest((ApplicationLink)applicationLink, (Request.MethodType)command.getMethodType(), (String)url);
        final MutableBoolean requestReturned404 = new MutableBoolean(false);
        try {
            log.debug("Making request to {}", (Object)url);
            request.execute(new ResponseHandler(){

                public void handle(Response response) throws ResponseException {
                    if (log.isTraceEnabled()) {
                        log.trace("Server response is: {}", (Object)response.getResponseBodyAsString());
                    }
                    requestReturned404.setValue(response.getStatusCode() == 404);
                }
            });
        }
        catch (ResponseException e) {
            log.debug(String.format("Error while performing GET request to '%s'", url), (Throwable)e);
        }
        return requestReturned404.booleanValue();
    }

    protected ServerInfo doAuthenticatedRequest(ApplicationLink applicationLink, RestCommand command) throws ResponseException, CredentialsRequiredException {
        final URI url = command.makeAbsoluteURL(applicationLink.getRpcUrl().toString());
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = (ApplicationLinkRequest)requestFactory.createRequest(Request.MethodType.GET, url.toString()).setFollowRedirects(true);
        log.debug("Making request to '{}'", (Object)url);
        return (ServerInfo)request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<ServerInfo>(){

            public ServerInfo credentialsRequired(Response response) throws ResponseException {
                log.warn("Request to '{}' requires OAuth credentials. Assuming FishEye+Crucible both available", (Object)url);
                return ServerInfo.fisheyeAndCrucible();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServerInfo handle(Response response) throws ResponseException {
                if (log.isTraceEnabled()) {
                    log.trace("Server response is: {}", (Object)response.getResponseBodyAsString());
                }
                if (response.getStatusCode() == 404) {
                    log.debug("Request to '{}' returned 404. Assuming Crucible standalone", (Object)url);
                    return ServerInfo.crucibleStandalone();
                }
                if (response.isSuccessful()) {
                    InputStream inputStream = response.getResponseBodyAsStream();
                    try {
                        ServerInfo serverInfo = ServerInfo.fromXML(inputStream);
                        log.debug("Request to '{}' returned {}", (Object)url, (Object)serverInfo);
                        ServerInfo serverInfo2 = serverInfo;
                        return serverInfo2;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                }
                log.warn("Request to '{}' returned status code {}. Assuming FishEye+Crucible both available", (Object)url, (Object)response.getStatusCode());
                return ServerInfo.fisheyeAndCrucible();
            }
        });
    }
}

