/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.fisheye;

import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.Refreshable;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.util.ConfigUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FishEyeConfigImpl
implements FishEyeConfig,
FishEyePropertyKeys,
Refreshable,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(FishEyeConfigImpl.class);
    private final FishEyeProperties properties;
    private final ConfigUtil configUtil;
    private final FishEyeInstanceStore fishEyeInstanceStore;
    private final RefreshManager refreshManager;
    private boolean isValid = true;
    private int revisionCacheSize;
    private int maxIssueChangeSets;
    private int maxProjectChangeSets;
    private int maxRevisions;
    private int maxDaysPrevious;
    private int maxCruDaysSearch;
    private Map<String, String> cruProjectsToUrls = Maps.newConcurrentMap();
    private boolean useCruTextSearch;
    private boolean useCruChangesetSearch;
    private boolean searchForMovedIssues;
    private boolean wikiRendering;
    private String cruSearchMethod;

    public FishEyeConfigImpl(FishEyeProperties fisheyeProperties, ConfigUtil configUtil, FishEyeInstanceStore fishEyeInstanceStore, RefreshManager refreshManager) {
        this.properties = fisheyeProperties;
        this.configUtil = configUtil;
        this.fishEyeInstanceStore = fishEyeInstanceStore;
        this.refreshManager = refreshManager;
    }

    @Override
    public boolean isValid() {
        if (!this.isValid && log.isDebugEnabled()) {
            log.debug("FishEyeConfigImpl.isValid() is returning false, dumping config values:");
            log.debug("fisheye.max.previous.days.search=" + this.maxDaysPrevious);
            log.debug("fisheye.crucible.max.days.search=" + this.maxCruDaysSearch);
            log.debug("fisheye.display.issue.maxchangesets=" + this.maxIssueChangeSets);
            log.debug("fisheye.display.project.maxchangesets=" + this.maxProjectChangeSets);
            log.debug("fisheye.display.maxrevisions=" + this.maxRevisions);
            log.debug("fisheye.revcache.size=" + this.revisionCacheSize);
        }
        return this.isValid;
    }

    @Override
    public int getRevisionCacheSize() {
        return this.revisionCacheSize;
    }

    @Override
    public int getMaxIssueChangeSets() {
        return this.maxIssueChangeSets;
    }

    @Override
    public int getMaxProjectChangesets() {
        return this.maxProjectChangeSets;
    }

    @Override
    public int getMaxRevisions() {
        return this.maxRevisions;
    }

    @Override
    public int getMaxDaysPrevious() {
        return this.maxDaysPrevious;
    }

    @Override
    public int getMaxCruDaysSearch() {
        return this.maxCruDaysSearch;
    }

    @Override
    public boolean isTextCruSearch() {
        return this.useCruTextSearch;
    }

    @Override
    public boolean isChangesetCruSearch() {
        return this.useCruChangesetSearch;
    }

    @Override
    public boolean isWikiRenderingEnabled() {
        return this.wikiRendering;
    }

    @Override
    public boolean isSearchForMovedIssues() {
        return this.searchForMovedIssues;
    }

    @Override
    public void reloadProperties() {
        this.isValid = true;
        this.validateConfiguration();
        this.reloadIntegerParams();
        this.reloadBooleanParams();
    }

    private void validateConfiguration() {
        this.isValid = !this.fishEyeInstanceStore.getAllFishEyeInstances().isEmpty();
    }

    protected void reloadIntegerParams() {
        this.revisionCacheSize = this.configUtil.retrieveValidatedInt("fisheye.revcache.size", 100000, 5000);
        this.maxIssueChangeSets = this.configUtil.retrieveValidatedInt("fisheye.display.issue.maxchangesets", 20);
        this.maxProjectChangeSets = this.configUtil.retrieveValidatedInt("fisheye.display.project.maxchangesets", 20);
        this.maxRevisions = this.configUtil.retrieveValidatedInt("fisheye.display.maxrevisions", 30);
        this.maxDaysPrevious = this.configUtil.retrieveValidatedInt("fisheye.max.previous.days.search", 30);
        this.maxCruDaysSearch = this.configUtil.retrieveValidatedInt("fisheye.crucible.max.days.search", 20);
    }

    private void reloadBooleanParams() {
        this.useCruChangesetSearch = false;
        this.useCruTextSearch = false;
        this.cruSearchMethod = this.properties.getString("fisheye.crucible.search.method");
        if ("cru.search.text.only".equals(this.cruSearchMethod)) {
            this.useCruTextSearch = true;
        } else if ("cru.search.revision.only".equals(this.cruSearchMethod)) {
            this.useCruChangesetSearch = true;
        } else {
            this.useCruTextSearch = true;
            this.useCruChangesetSearch = true;
        }
        Boolean searchMovedObj = this.properties.getBoolean("fisheye.search.moved.issues");
        this.searchForMovedIssues = searchMovedObj == null || searchMovedObj != false;
        Boolean wikiRenderingObj = this.properties.getBoolean("fisheye.display.wiki.render");
        this.wikiRendering = wikiRenderingObj != null && wikiRenderingObj != false;
    }

    @Override
    public boolean isCrucibleEnabled() {
        return this.properties.getBooleanPrimitive("fisheye.crucible.enabled");
    }

    @Override
    public Map<String, String> getCrucibleProjectToUrlMappings() {
        return this.cruProjectsToUrls;
    }

    @Override
    public void setCrucibleProjectToUrlMappings(Map<String, String> mappings) {
        this.cruProjectsToUrls.clear();
        this.cruProjectsToUrls.putAll(mappings);
    }

    @Override
    public String getCruSearchMethod() {
        return this.cruSearchMethod;
    }

    @Override
    public void refresh() {
        this.reloadProperties();
    }

    @Override
    public int order() {
        return 10;
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshManager.registerRefreshable(this);
    }
}

