/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.crucible;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jirafisheyeplugin.config.JiraProjectKeyToIdConverter;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.config.properties.CollectionApplicationLinkProperty;
import com.atlassian.jirafisheyeplugin.config.properties.CollectionProjectProperty;
import com.atlassian.jirafisheyeplugin.config.properties.ProjectKey;
import com.atlassian.jirafisheyeplugin.config.properties.StringProjectProperty;
import com.atlassian.jirafisheyeplugin.config.ual.UalUtil;
import com.atlassian.jirafisheyeplugin.util.Util;
import java.util.Collection;
import java.util.Date;

public class CrucibleProjectStoreImpl
implements CrucibleProjectStore {
    private static final CollectionApplicationLinkProperty<String> ALL_CRUCIBLE_PROJECTS = new CollectionApplicationLinkProperty<String>(FishEyePropertyKeys.CRUCIBLE_PROJECTS_ALL, CollectionProjectProperty.IDENTITY_CONVERTER);
    private static final StringProjectProperty<ProjectKey.JIRA> DEFAULT_JIRA_PROJECT_TO_CRUCIBLE_PROJECT_MAPPING = new StringProjectProperty("fisheye.default.crucible.project.", "");
    private final ApplicationLinkService applicationLinkService;
    private final FishEyeProperties properties;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext authenticationContext;
    private final CollectionProjectProperty<ProjectKey.CRUCIBLE, Long> crucibleProjectToJiraProjectMapping;
    private final JiraProjectKeyToIdConverter jiraProjectKeyToIdConverter;

    public CrucibleProjectStoreImpl(ApplicationLinkService applicationLinkService, FishEyeProperties properties, ProjectManager projectManager, JiraAuthenticationContext authenticationContext) {
        this.applicationLinkService = applicationLinkService;
        this.properties = properties;
        this.projectManager = projectManager;
        this.authenticationContext = authenticationContext;
        this.jiraProjectKeyToIdConverter = new JiraProjectKeyToIdConverter(projectManager);
        this.crucibleProjectToJiraProjectMapping = new CollectionProjectProperty("fisheye.crucible.", ".projects", this.jiraProjectKeyToIdConverter);
    }

    @Override
    public Collection<Long> getJiraProjectsMappedToCrucibleProject(String crucibleProjectKey, ApplicationId id) {
        return this.crucibleProjectToJiraProjectMapping.get(UalUtil.idToLink(this.applicationLinkService, id), (ProjectKey)new ProjectKey.CRUCIBLE(crucibleProjectKey));
    }

    @Override
    public String getDefaultCrucibleProjectKey(String jiraProjectKey, ApplicationId id) {
        return DEFAULT_JIRA_PROJECT_TO_CRUCIBLE_PROJECT_MAPPING.get(UalUtil.idToLink(this.applicationLinkService, id), (ProjectKey)new ProjectKey.JIRA(jiraProjectKey));
    }

    private void setDefaultCrucibleProject(ProjectKey.JIRA jiraProjectKey, String crucibleProjectKey, ApplicationLink link) {
        DEFAULT_JIRA_PROJECT_TO_CRUCIBLE_PROJECT_MAPPING.set(link, jiraProjectKey, crucibleProjectKey);
    }

    @Override
    public void setDefaultCrucibleProject(Collection<Long> jiraProjectIds, String crucibleProjectKey, ApplicationId id) {
        ApplicationLink link = UalUtil.idToLink(this.applicationLinkService, id);
        this.crucibleProjectToJiraProjectMapping.set(link, new ProjectKey.CRUCIBLE(crucibleProjectKey), jiraProjectIds);
        for (Long jiraProjectId : jiraProjectIds) {
            this.setDefaultCrucibleProject(new ProjectKey.JIRA(this.jiraProjectKeyToIdConverter.fromValue(jiraProjectId)), crucibleProjectKey, link);
        }
    }

    @Override
    public void clearProjectMappingsForInstance(ApplicationId id) {
        for (Project project : this.projectManager.getProjectObjects()) {
            DEFAULT_JIRA_PROJECT_TO_CRUCIBLE_PROJECT_MAPPING.remove(UalUtil.idToLink(this.applicationLinkService, id), new ProjectKey.JIRA(project.getKey()));
        }
    }

    @Override
    public Collection<String> getCrucibleProjectKeys(ApplicationId instanceId) {
        return ALL_CRUCIBLE_PROJECTS.get(UalUtil.idToLink(this.applicationLinkService, instanceId));
    }

    @Override
    public void setCrucibleProjectKeys(Collection<String> crucibleProjectKeys, ApplicationId id) {
        ALL_CRUCIBLE_PROJECTS.set(UalUtil.idToLink(this.applicationLinkService, id), crucibleProjectKeys);
        this.properties.setString("fisheye.crucible.projects.last.updated", Util.formatDate("EEE, d MMM yyyy HH:mm:ss Z", new Date(), this.authenticationContext.getLocale()));
    }

    @Override
    public String getCrucibleProjectKeysLastUpdated() {
        return this.properties.getString("fisheye.crucible.projects.last.updated");
    }
}

