/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config.crucible;

import com.atlassian.jira.project.Project;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectManager;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CrucibleProjectManagerImpl
implements CrucibleProjectManager {
    private final FishEyeManager fishEyeManager;
    private final CrucibleProjectStore crucibleProjectStore;

    public CrucibleProjectManagerImpl(FishEyeManager fishEyeManager, CrucibleProjectStore crucibleProjectStore) {
        this.fishEyeManager = fishEyeManager;
        this.crucibleProjectStore = crucibleProjectStore;
    }

    @Override
    public List<String> getKeysForInstance(FishEyeInstance fishEyeInstance) {
        return Lists.newArrayList(this.crucibleProjectStore.getCrucibleProjectKeys(fishEyeInstance.getApplicationId()));
    }

    @Override
    public void addMapping(FishEyeInstance fishEyeInstance, Project jiraProject, String crucibleProjectKey) {
        Collection<Long> alreadyMappedJiraProjectIds = this.crucibleProjectStore.getJiraProjectsMappedToCrucibleProject(crucibleProjectKey, fishEyeInstance.getApplicationId());
        ArrayList newMappings = Lists.newArrayList(alreadyMappedJiraProjectIds);
        if (newMappings.add(jiraProject.getId())) {
            this.crucibleProjectStore.setDefaultCrucibleProject(newMappings, crucibleProjectKey, fishEyeInstance.getApplicationId());
        }
    }

    @Override
    public void removeMapping(FishEyeInstance fishEyeInstance, Project jiraProject, String crucibleProjectKey) {
        Collection<Long> alreadyMappedJiraProjectIds = this.crucibleProjectStore.getJiraProjectsMappedToCrucibleProject(crucibleProjectKey, fishEyeInstance.getApplicationId());
        ArrayList newMappings = Lists.newArrayList(alreadyMappedJiraProjectIds);
        boolean removed = false;
        while (newMappings.contains(jiraProject.getId())) {
            newMappings.remove(jiraProject.getId());
            removed = true;
        }
        if (removed) {
            this.crucibleProjectStore.setDefaultCrucibleProject(newMappings, crucibleProjectKey, fishEyeInstance.getApplicationId());
            this.fishEyeManager.refreshConfig();
        }
    }
}

