/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jirafisheyeplugin.config.JiraFisheyeStartRefreshEvent;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.config.Refreshable;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeProperties;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class RefreshManagerImpl
implements RefreshManager,
InitializingBean,
DisposableBean,
ClusterMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(RefreshManager.class);
    private static final String RELOAD_ON_CLEAR_CACHE = "jira.fisheye.reloadOnClearCache";
    private static final String CHANNEL = "fecru-refresh";
    private static final String MESSAGE = "Refresh FishEye caches";
    private final List<Refreshable> refreshables = new LinkedList<Refreshable>();
    private final EventPublisher eventPublisher;
    private final FishEyeProperties fishEyeProperties;
    private final ServiceManager serviceManager;
    private final ClusterMessagingService clusterMessagingService;

    public RefreshManagerImpl(EventPublisher eventPublisher, FishEyeProperties fishEyeProperties, ServiceManager serviceManager, ClusterMessagingService clusterMessagingService) {
        this.eventPublisher = eventPublisher;
        this.fishEyeProperties = fishEyeProperties;
        this.serviceManager = serviceManager;
        this.clusterMessagingService = clusterMessagingService;
        clusterMessagingService.registerListener(CHANNEL, (ClusterMessageConsumer)this);
    }

    @Override
    public synchronized void registerRefreshable(Refreshable newRefreshable) {
        for (int i = 0; i < this.refreshables.size(); ++i) {
            Refreshable existingRefreshable = this.refreshables.get(i);
            if (!existingRefreshable.getClass().equals(newRefreshable.getClass())) continue;
            this.refreshables.remove(i);
            this.refreshables.add(i, newRefreshable);
            return;
        }
        this.refreshables.add(newRefreshable);
        Collections.sort(this.refreshables, Refreshable.COMPARATOR);
    }

    @Override
    public synchronized void refreshAll() {
        log.info(String.format("Refreshing %d FishEye plugin components : %s ", this.refreshables.size(), this.getPrintableNamesOf(this.refreshables)));
        this.clusterMessagingService.sendRemote(CHANNEL, MESSAGE);
        this.refreshRefreshables();
    }

    private String getPrintableNamesOf(List<Refreshable> refreshables) {
        return Lists.transform(refreshables, (Function)new Function<Refreshable, String>(){

            public String apply(Refreshable from) {
                return from.getClass().getSimpleName();
            }
        }).toString();
    }

    @EventListener
    public void onStart(JiraStartedEvent event) {
        this.eventPublisher.publish((Object)new JiraFisheyeStartRefreshEvent());
        this.refreshAll();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        if (Boolean.TRUE.toString().equals(System.getProperty(RELOAD_ON_CLEAR_CACHE, Boolean.TRUE.toString()))) {
            this.fishEyeProperties.refresh();
            this.refreshAll();
        }
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (event.getPlugin().getKey().equals("com.atlassian.jirafisheyeplugin")) {
            try {
                this.serviceManager.getServices();
            }
            catch (IllegalStateException e) {
                return;
            }
            this.eventPublisher.publish((Object)new JiraFisheyeStartRefreshEvent());
            this.refreshAll();
        }
    }

    public void afterPropertiesSet() {
        log.debug("registering RefreshManager to " + EventPublisher.class.getSimpleName());
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
        this.clusterMessagingService.unregisterListener(CHANNEL, (ClusterMessageConsumer)this);
        this.refreshables.clear();
    }

    public void receive(String channel, String message, String nodeId) {
        if (CHANNEL.equals(channel) && MESSAGE.equals(message)) {
            this.fishEyeProperties.refresh();
            this.refreshRefreshables();
        }
    }

    private void refreshRefreshables() {
        for (Refreshable refreshable : this.refreshables) {
            try {
                refreshable.refresh();
            }
            catch (Exception e) {
                log.error(String.format("Exception occurred when refreshing %s : %s", refreshable, e.getMessage()), (Throwable)e);
            }
        }
    }
}

